/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.Workteam;

public class ListWorkteamsIterable
implements SdkIterable<ListWorkteamsResponse> {
    private final SageMakerClient client;
    private final ListWorkteamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkteamsIterable(SageMakerClient client, ListWorkteamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkteamsResponseFetcher();
    }

    public Iterator<ListWorkteamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Workteam> workteams() {
        Function<ListWorkteamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workteams() != null) {
                return response.workteams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkteamsResponseFetcher
    implements SyncPageFetcher<ListWorkteamsResponse> {
        private ListWorkteamsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkteamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkteamsResponse nextPage(ListWorkteamsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkteamsIterable.this.client.listWorkteams(ListWorkteamsIterable.this.firstRequest);
            }
            return ListWorkteamsIterable.this.client.listWorkteams((ListWorkteamsRequest)((Object)ListWorkteamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

