/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContentTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinitionListCopier;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import software.amazon.awssdk.services.sagemaker.model.RealtimeInferenceInstanceTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.ResponseMIMETypesCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformInstanceType;
import software.amazon.awssdk.services.sagemaker.model.TransformInstanceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceSpecification> {
    private static final SdkField<List<ModelPackageContainerDefinition>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Containers").getter(InferenceSpecification.getter(InferenceSpecification::containers)).setter(InferenceSpecification.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTransformInstanceTypes").getter(InferenceSpecification.getter(InferenceSpecification::supportedTransformInstanceTypesAsStrings)).setter(InferenceSpecification.setter(Builder::supportedTransformInstanceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTransformInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedRealtimeInferenceInstanceTypes").getter(InferenceSpecification.getter(InferenceSpecification::supportedRealtimeInferenceInstanceTypesAsStrings)).setter(InferenceSpecification.setter(Builder::supportedRealtimeInferenceInstanceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedRealtimeInferenceInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedContentTypes").getter(InferenceSpecification.getter(InferenceSpecification::supportedContentTypes)).setter(InferenceSpecification.setter(Builder::supportedContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_RESPONSE_MIME_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedResponseMIMETypes").getter(InferenceSpecification.getter(InferenceSpecification::supportedResponseMIMETypes)).setter(InferenceSpecification.setter(Builder::supportedResponseMIMETypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedResponseMIMETypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD, SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD, SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD, SUPPORTED_CONTENT_TYPES_FIELD, SUPPORTED_RESPONSE_MIME_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ModelPackageContainerDefinition> containers;
    private final List<String> supportedTransformInstanceTypes;
    private final List<String> supportedRealtimeInferenceInstanceTypes;
    private final List<String> supportedContentTypes;
    private final List<String> supportedResponseMIMETypes;

    private InferenceSpecification(BuilderImpl builder) {
        this.containers = builder.containers;
        this.supportedTransformInstanceTypes = builder.supportedTransformInstanceTypes;
        this.supportedRealtimeInferenceInstanceTypes = builder.supportedRealtimeInferenceInstanceTypes;
        this.supportedContentTypes = builder.supportedContentTypes;
        this.supportedResponseMIMETypes = builder.supportedResponseMIMETypes;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<ModelPackageContainerDefinition> containers() {
        return this.containers;
    }

    public final List<TransformInstanceType> supportedTransformInstanceTypes() {
        return TransformInstanceTypesCopier.copyStringToEnum(this.supportedTransformInstanceTypes);
    }

    public final boolean hasSupportedTransformInstanceTypes() {
        return this.supportedTransformInstanceTypes != null && !(this.supportedTransformInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedTransformInstanceTypesAsStrings() {
        return this.supportedTransformInstanceTypes;
    }

    public final List<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes() {
        return RealtimeInferenceInstanceTypesCopier.copyStringToEnum(this.supportedRealtimeInferenceInstanceTypes);
    }

    public final boolean hasSupportedRealtimeInferenceInstanceTypes() {
        return this.supportedRealtimeInferenceInstanceTypes != null && !(this.supportedRealtimeInferenceInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedRealtimeInferenceInstanceTypesAsStrings() {
        return this.supportedRealtimeInferenceInstanceTypes;
    }

    public final boolean hasSupportedContentTypes() {
        return this.supportedContentTypes != null && !(this.supportedContentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedContentTypes() {
        return this.supportedContentTypes;
    }

    public final boolean hasSupportedResponseMIMETypes() {
        return this.supportedResponseMIMETypes != null && !(this.supportedResponseMIMETypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedResponseMIMETypes() {
        return this.supportedResponseMIMETypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTransformInstanceTypes() ? this.supportedTransformInstanceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedRealtimeInferenceInstanceTypes() ? this.supportedRealtimeInferenceInstanceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedContentTypes() ? this.supportedContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedResponseMIMETypes() ? this.supportedResponseMIMETypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceSpecification)) {
            return false;
        }
        InferenceSpecification other = (InferenceSpecification)obj;
        return this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && this.hasSupportedTransformInstanceTypes() == other.hasSupportedTransformInstanceTypes() && Objects.equals(this.supportedTransformInstanceTypesAsStrings(), other.supportedTransformInstanceTypesAsStrings()) && this.hasSupportedRealtimeInferenceInstanceTypes() == other.hasSupportedRealtimeInferenceInstanceTypes() && Objects.equals(this.supportedRealtimeInferenceInstanceTypesAsStrings(), other.supportedRealtimeInferenceInstanceTypesAsStrings()) && this.hasSupportedContentTypes() == other.hasSupportedContentTypes() && Objects.equals(this.supportedContentTypes(), other.supportedContentTypes()) && this.hasSupportedResponseMIMETypes() == other.hasSupportedResponseMIMETypes() && Objects.equals(this.supportedResponseMIMETypes(), other.supportedResponseMIMETypes());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceSpecification").add("Containers", this.hasContainers() ? this.containers() : null).add("SupportedTransformInstanceTypes", this.hasSupportedTransformInstanceTypes() ? this.supportedTransformInstanceTypesAsStrings() : null).add("SupportedRealtimeInferenceInstanceTypes", this.hasSupportedRealtimeInferenceInstanceTypes() ? this.supportedRealtimeInferenceInstanceTypesAsStrings() : null).add("SupportedContentTypes", this.hasSupportedContentTypes() ? this.supportedContentTypes() : null).add("SupportedResponseMIMETypes", this.hasSupportedResponseMIMETypes() ? this.supportedResponseMIMETypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "SupportedTransformInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedTransformInstanceTypesAsStrings()));
            }
            case "SupportedRealtimeInferenceInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedRealtimeInferenceInstanceTypesAsStrings()));
            }
            case "SupportedContentTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedContentTypes()));
            }
            case "SupportedResponseMIMETypes": {
                return Optional.ofNullable(clazz.cast(this.supportedResponseMIMETypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceSpecification, T> g) {
        return obj -> g.apply((InferenceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ModelPackageContainerDefinition> containers = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedTransformInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedRealtimeInferenceInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedContentTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedResponseMIMETypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceSpecification model) {
            this.containers(model.containers);
            this.supportedTransformInstanceTypesWithStrings(model.supportedTransformInstanceTypes);
            this.supportedRealtimeInferenceInstanceTypesWithStrings(model.supportedRealtimeInferenceInstanceTypes);
            this.supportedContentTypes(model.supportedContentTypes);
            this.supportedResponseMIMETypes(model.supportedResponseMIMETypes);
        }

        public final List<ModelPackageContainerDefinition.Builder> getContainers() {
            List<ModelPackageContainerDefinition.Builder> result = ModelPackageContainerDefinitionListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<ModelPackageContainerDefinition.BuilderImpl> containers) {
            this.containers = ModelPackageContainerDefinitionListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<ModelPackageContainerDefinition> containers) {
            this.containers = ModelPackageContainerDefinitionListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ModelPackageContainerDefinition ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ModelPackageContainerDefinition.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (ModelPackageContainerDefinition)((ModelPackageContainerDefinition.Builder)ModelPackageContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedTransformInstanceTypes() {
            if (this.supportedTransformInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedTransformInstanceTypes;
        }

        public final void setSupportedTransformInstanceTypes(Collection<String> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copy(supportedTransformInstanceTypes);
        }

        @Override
        public final Builder supportedTransformInstanceTypesWithStrings(Collection<String> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copy(supportedTransformInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTransformInstanceTypesWithStrings(String ... supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypesWithStrings(Arrays.asList(supportedTransformInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedTransformInstanceTypes(Collection<TransformInstanceType> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copyEnumToString(supportedTransformInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTransformInstanceTypes(TransformInstanceType ... supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes(Arrays.asList(supportedTransformInstanceTypes));
            return this;
        }

        public final Collection<String> getSupportedRealtimeInferenceInstanceTypes() {
            if (this.supportedRealtimeInferenceInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedRealtimeInferenceInstanceTypes;
        }

        public final void setSupportedRealtimeInferenceInstanceTypes(Collection<String> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier.copy(supportedRealtimeInferenceInstanceTypes);
        }

        @Override
        public final Builder supportedRealtimeInferenceInstanceTypesWithStrings(Collection<String> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier.copy(supportedRealtimeInferenceInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRealtimeInferenceInstanceTypesWithStrings(String ... supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypesWithStrings(Arrays.asList(supportedRealtimeInferenceInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedRealtimeInferenceInstanceTypes(Collection<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier.copyEnumToString(supportedRealtimeInferenceInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRealtimeInferenceInstanceTypes(ProductionVariantInstanceType ... supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes(Arrays.asList(supportedRealtimeInferenceInstanceTypes));
            return this;
        }

        public final Collection<String> getSupportedContentTypes() {
            if (this.supportedContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedContentTypes;
        }

        public final void setSupportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
        }

        @Override
        public final Builder supportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedContentTypes(String ... supportedContentTypes) {
            this.supportedContentTypes(Arrays.asList(supportedContentTypes));
            return this;
        }

        public final Collection<String> getSupportedResponseMIMETypes() {
            if (this.supportedResponseMIMETypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedResponseMIMETypes;
        }

        public final void setSupportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes = ResponseMIMETypesCopier.copy(supportedResponseMIMETypes);
        }

        @Override
        public final Builder supportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes = ResponseMIMETypesCopier.copy(supportedResponseMIMETypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedResponseMIMETypes(String ... supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes(Arrays.asList(supportedResponseMIMETypes));
            return this;
        }

        public InferenceSpecification build() {
            return new InferenceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceSpecification> {
        public Builder containers(Collection<ModelPackageContainerDefinition> var1);

        public Builder containers(ModelPackageContainerDefinition ... var1);

        public Builder containers(Consumer<ModelPackageContainerDefinition.Builder> ... var1);

        public Builder supportedTransformInstanceTypesWithStrings(Collection<String> var1);

        public Builder supportedTransformInstanceTypesWithStrings(String ... var1);

        public Builder supportedTransformInstanceTypes(Collection<TransformInstanceType> var1);

        public Builder supportedTransformInstanceTypes(TransformInstanceType ... var1);

        public Builder supportedRealtimeInferenceInstanceTypesWithStrings(Collection<String> var1);

        public Builder supportedRealtimeInferenceInstanceTypesWithStrings(String ... var1);

        public Builder supportedRealtimeInferenceInstanceTypes(Collection<ProductionVariantInstanceType> var1);

        public Builder supportedRealtimeInferenceInstanceTypes(ProductionVariantInstanceType ... var1);

        public Builder supportedContentTypes(Collection<String> var1);

        public Builder supportedContentTypes(String ... var1);

        public Builder supportedResponseMIMETypes(Collection<String> var1);

        public Builder supportedResponseMIMETypes(String ... var1);
    }
}

