/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelCompressionType;
import software.amazon.awssdk.services.sagemaker.model.S3ModelDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ModelDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ModelDataSource> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(S3ModelDataSource.getter(S3ModelDataSource::s3Uri)).setter(S3ModelDataSource.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataType").getter(S3ModelDataSource.getter(S3ModelDataSource::s3DataTypeAsString)).setter(S3ModelDataSource.setter(Builder::s3DataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(S3ModelDataSource.getter(S3ModelDataSource::compressionTypeAsString)).setter(S3ModelDataSource.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, S3_DATA_TYPE_FIELD, COMPRESSION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String s3DataType;
    private final String compressionType;

    private S3ModelDataSource(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.s3DataType = builder.s3DataType;
        this.compressionType = builder.compressionType;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final S3ModelDataType s3DataType() {
        return S3ModelDataType.fromValue(this.s3DataType);
    }

    public final String s3DataTypeAsString() {
        return this.s3DataType;
    }

    public final ModelCompressionType compressionType() {
        return ModelCompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ModelDataSource)) {
            return false;
        }
        S3ModelDataSource other = (S3ModelDataSource)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3ModelDataSource").add("S3Uri", (Object)this.s3Uri()).add("S3DataType", (Object)this.s3DataTypeAsString()).add("CompressionType", (Object)this.compressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "S3DataType": {
                return Optional.ofNullable(clazz.cast(this.s3DataTypeAsString()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ModelDataSource, T> g) {
        return obj -> g.apply((S3ModelDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String s3DataType;
        private String compressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ModelDataSource model) {
            this.s3Uri(model.s3Uri);
            this.s3DataType(model.s3DataType);
            this.compressionType(model.compressionType);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3DataType() {
            return this.s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(S3ModelDataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(ModelCompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public S3ModelDataSource build() {
            return new S3ModelDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ModelDataSource> {
        public Builder s3Uri(String var1);

        public Builder s3DataType(String var1);

        public Builder s3DataType(S3ModelDataType var1);

        public Builder compressionType(String var1);

        public Builder compressionType(ModelCompressionType var1);
    }
}

