/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse;

public class ListLineageGroupsIterable
implements SdkIterable<ListLineageGroupsResponse> {
    private final SageMakerClient client;
    private final ListLineageGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLineageGroupsIterable(SageMakerClient client, ListLineageGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLineageGroupsResponseFetcher();
    }

    public Iterator<ListLineageGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LineageGroupSummary> lineageGroupSummaries() {
        Function<ListLineageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lineageGroupSummaries() != null) {
                return response.lineageGroupSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLineageGroupsResponseFetcher
    implements SyncPageFetcher<ListLineageGroupsResponse> {
        private ListLineageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListLineageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLineageGroupsResponse nextPage(ListLineageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListLineageGroupsIterable.this.client.listLineageGroups(ListLineageGroupsIterable.this.firstRequest);
            }
            return ListLineageGroupsIterable.this.client.listLineageGroups((ListLineageGroupsRequest)((Object)ListLineageGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

