/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse;

public class ListInferenceExperimentsPublisher
implements SdkPublisher<ListInferenceExperimentsResponse> {
    private final SageMakerAsyncClient client;
    private final ListInferenceExperimentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceExperimentsPublisher(SageMakerAsyncClient client, ListInferenceExperimentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceExperimentsPublisher(SageMakerAsyncClient client, ListInferenceExperimentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceExperimentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceExperimentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InferenceExperimentSummary> inferenceExperiments() {
        Function<ListInferenceExperimentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceExperiments() != null) {
                return response.inferenceExperiments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInferenceExperimentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInferenceExperimentsResponseFetcher
    implements AsyncPageFetcher<ListInferenceExperimentsResponse> {
        private ListInferenceExperimentsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceExperimentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceExperimentsResponse> nextPage(ListInferenceExperimentsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceExperimentsPublisher.this.client.listInferenceExperiments(ListInferenceExperimentsPublisher.this.firstRequest);
            }
            return ListInferenceExperimentsPublisher.this.client.listInferenceExperiments((ListInferenceExperimentsRequest)((Object)ListInferenceExperimentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

