/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetPlatformOs {
    ANDROID("ANDROID"),
    LINUX("LINUX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetPlatformOs> VALUE_MAP;
    private final String value;

    private TargetPlatformOs(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetPlatformOs fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetPlatformOs> knownValues() {
        EnumSet<TargetPlatformOs> knownValues = EnumSet.allOf(TargetPlatformOs.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetPlatformOs.class, TargetPlatformOs::toString);
    }
}

