/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary;

public class ListTrialComponentsIterable
implements SdkIterable<ListTrialComponentsResponse> {
    private final SageMakerClient client;
    private final ListTrialComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrialComponentsIterable(SageMakerClient client, ListTrialComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrialComponentsResponseFetcher();
    }

    public Iterator<ListTrialComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrialComponentSummary> trialComponentSummaries() {
        Function<ListTrialComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trialComponentSummaries() != null) {
                return response.trialComponentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrialComponentsResponseFetcher
    implements SyncPageFetcher<ListTrialComponentsResponse> {
        private ListTrialComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrialComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrialComponentsResponse nextPage(ListTrialComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListTrialComponentsIterable.this.client.listTrialComponents(ListTrialComponentsIterable.this.firstRequest);
            }
            return ListTrialComponentsIterable.this.client.listTrialComponents((ListTrialComponentsRequest)((Object)ListTrialComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

