/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3DataType {
    MANIFEST_FILE("ManifestFile"),
    S3_PREFIX("S3Prefix"),
    AUGMENTED_MANIFEST_FILE("AugmentedManifestFile"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3DataType> VALUE_MAP;
    private final String value;

    private S3DataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3DataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3DataType> knownValues() {
        EnumSet<S3DataType> knownValues = EnumSet.allOf(S3DataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3DataType.class, S3DataType::toString);
    }
}

