/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus;
import software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgePresetDeploymentOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgePresetDeploymentOutput> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(EdgePresetDeploymentOutput.getter(EdgePresetDeploymentOutput::typeAsString)).setter(EdgePresetDeploymentOutput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Artifact").getter(EdgePresetDeploymentOutput.getter(EdgePresetDeploymentOutput::artifact)).setter(EdgePresetDeploymentOutput.setter(Builder::artifact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Artifact").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EdgePresetDeploymentOutput.getter(EdgePresetDeploymentOutput::statusAsString)).setter(EdgePresetDeploymentOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(EdgePresetDeploymentOutput.getter(EdgePresetDeploymentOutput::statusMessage)).setter(EdgePresetDeploymentOutput.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ARTIFACT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String artifact;
    private final String status;
    private final String statusMessage;

    private EdgePresetDeploymentOutput(BuilderImpl builder) {
        this.type = builder.type;
        this.artifact = builder.artifact;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final EdgePresetDeploymentType type() {
        return EdgePresetDeploymentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String artifact() {
        return this.artifact;
    }

    public final EdgePresetDeploymentStatus status() {
        return EdgePresetDeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgePresetDeploymentOutput)) {
            return false;
        }
        EdgePresetDeploymentOutput other = (EdgePresetDeploymentOutput)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.artifact(), other.artifact()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"EdgePresetDeploymentOutput").add("Type", (Object)this.typeAsString()).add("Artifact", (Object)this.artifact()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Artifact": {
                return Optional.ofNullable(clazz.cast(this.artifact()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgePresetDeploymentOutput, T> g) {
        return obj -> g.apply((EdgePresetDeploymentOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String artifact;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgePresetDeploymentOutput model) {
            this.type(model.type);
            this.artifact(model.artifact);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EdgePresetDeploymentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getArtifact() {
            return this.artifact;
        }

        public final void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        @Override
        public final Builder artifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EdgePresetDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public EdgePresetDeploymentOutput build() {
            return new EdgePresetDeploymentOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgePresetDeploymentOutput> {
        public Builder type(String var1);

        public Builder type(EdgePresetDeploymentType var1);

        public Builder artifact(String var1);

        public Builder status(String var1);

        public Builder status(EdgePresetDeploymentStatus var1);

        public Builder statusMessage(String var1);
    }
}

