/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLProcessingUnit {
    CPU("CPU"),
    GPU("GPU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLProcessingUnit> VALUE_MAP;
    private final String value;

    private AutoMLProcessingUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLProcessingUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLProcessingUnit> knownValues() {
        EnumSet<AutoMLProcessingUnit> knownValues = EnumSet.allOf(AutoMLProcessingUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLProcessingUnit.class, AutoMLProcessingUnit::toString);
    }
}

