/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig;
import software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShadowModeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShadowModeConfig> {
    private static final SdkField<String> SOURCE_MODEL_VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceModelVariantName").getter(ShadowModeConfig.getter(ShadowModeConfig::sourceModelVariantName)).setter(ShadowModeConfig.setter(Builder::sourceModelVariantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVariantName").build()}).build();
    private static final SdkField<List<ShadowModelVariantConfig>> SHADOW_MODEL_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShadowModelVariants").getter(ShadowModeConfig.getter(ShadowModeConfig::shadowModelVariants)).setter(ShadowModeConfig.setter(Builder::shadowModelVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModelVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShadowModelVariantConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_MODEL_VARIANT_NAME_FIELD, SHADOW_MODEL_VARIANTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceModelVariantName;
    private final List<ShadowModelVariantConfig> shadowModelVariants;

    private ShadowModeConfig(BuilderImpl builder) {
        this.sourceModelVariantName = builder.sourceModelVariantName;
        this.shadowModelVariants = builder.shadowModelVariants;
    }

    public final String sourceModelVariantName() {
        return this.sourceModelVariantName;
    }

    public final boolean hasShadowModelVariants() {
        return this.shadowModelVariants != null && !(this.shadowModelVariants instanceof SdkAutoConstructList);
    }

    public final List<ShadowModelVariantConfig> shadowModelVariants() {
        return this.shadowModelVariants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelVariantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShadowModelVariants() ? this.shadowModelVariants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShadowModeConfig)) {
            return false;
        }
        ShadowModeConfig other = (ShadowModeConfig)obj;
        return Objects.equals(this.sourceModelVariantName(), other.sourceModelVariantName()) && this.hasShadowModelVariants() == other.hasShadowModelVariants() && Objects.equals(this.shadowModelVariants(), other.shadowModelVariants());
    }

    public final String toString() {
        return ToString.builder((String)"ShadowModeConfig").add("SourceModelVariantName", (Object)this.sourceModelVariantName()).add("ShadowModelVariants", this.hasShadowModelVariants() ? this.shadowModelVariants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceModelVariantName": {
                return Optional.ofNullable(clazz.cast(this.sourceModelVariantName()));
            }
            case "ShadowModelVariants": {
                return Optional.ofNullable(clazz.cast(this.shadowModelVariants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShadowModeConfig, T> g) {
        return obj -> g.apply((ShadowModeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceModelVariantName;
        private List<ShadowModelVariantConfig> shadowModelVariants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ShadowModeConfig model) {
            this.sourceModelVariantName(model.sourceModelVariantName);
            this.shadowModelVariants(model.shadowModelVariants);
        }

        public final String getSourceModelVariantName() {
            return this.sourceModelVariantName;
        }

        public final void setSourceModelVariantName(String sourceModelVariantName) {
            this.sourceModelVariantName = sourceModelVariantName;
        }

        @Override
        public final Builder sourceModelVariantName(String sourceModelVariantName) {
            this.sourceModelVariantName = sourceModelVariantName;
            return this;
        }

        public final List<ShadowModelVariantConfig.Builder> getShadowModelVariants() {
            List<ShadowModelVariantConfig.Builder> result = ShadowModelVariantConfigListCopier.copyToBuilder(this.shadowModelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowModelVariants(Collection<ShadowModelVariantConfig.BuilderImpl> shadowModelVariants) {
            this.shadowModelVariants = ShadowModelVariantConfigListCopier.copyFromBuilder(shadowModelVariants);
        }

        @Override
        public final Builder shadowModelVariants(Collection<ShadowModelVariantConfig> shadowModelVariants) {
            this.shadowModelVariants = ShadowModelVariantConfigListCopier.copy(shadowModelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowModelVariants(ShadowModelVariantConfig ... shadowModelVariants) {
            this.shadowModelVariants(Arrays.asList(shadowModelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowModelVariants(Consumer<ShadowModelVariantConfig.Builder> ... shadowModelVariants) {
            this.shadowModelVariants(Stream.of(shadowModelVariants).map(c -> (ShadowModelVariantConfig)((ShadowModelVariantConfig.Builder)ShadowModelVariantConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ShadowModeConfig build() {
            return new ShadowModeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShadowModeConfig> {
        public Builder sourceModelVariantName(String var1);

        public Builder shadowModelVariants(Collection<ShadowModelVariantConfig> var1);

        public Builder shadowModelVariants(ShadowModelVariantConfig ... var1);

        public Builder shadowModelVariants(Consumer<ShadowModelVariantConfig.Builder> ... var1);
    }
}

