/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitoringType {
    DATA_QUALITY("DataQuality"),
    MODEL_QUALITY("ModelQuality"),
    MODEL_BIAS("ModelBias"),
    MODEL_EXPLAINABILITY("ModelExplainability"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitoringType> VALUE_MAP;
    private final String value;

    private MonitoringType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitoringType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitoringType> knownValues() {
        EnumSet<MonitoringType> knownValues = EnumSet.allOf(MonitoringType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitoringType.class, MonitoringType::toString);
    }
}

