/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinition;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.LastUpdateStatus;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus;
import software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFeatureGroupResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeFeatureGroupResponse> {
    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupArn").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::featureGroupArn)).setter(DescribeFeatureGroupResponse.setter(Builder::featureGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::featureGroupName)).setter(DescribeFeatureGroupResponse.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> RECORD_IDENTIFIER_FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordIdentifierFeatureName").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::recordIdentifierFeatureName)).setter(DescribeFeatureGroupResponse.setter(Builder::recordIdentifierFeatureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierFeatureName").build()}).build();
    private static final SdkField<String> EVENT_TIME_FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventTimeFeatureName").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::eventTimeFeatureName)).setter(DescribeFeatureGroupResponse.setter(Builder::eventTimeFeatureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeFeatureName").build()}).build();
    private static final SdkField<List<FeatureDefinition>> FEATURE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureDefinitions").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::featureDefinitions)).setter(DescribeFeatureGroupResponse.setter(Builder::featureDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::creationTime)).setter(DescribeFeatureGroupResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::lastModifiedTime)).setter(DescribeFeatureGroupResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<OnlineStoreConfig> ONLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnlineStoreConfig").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::onlineStoreConfig)).setter(DescribeFeatureGroupResponse.setter(Builder::onlineStoreConfig)).constructor(OnlineStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()}).build();
    private static final SdkField<OfflineStoreConfig> OFFLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfflineStoreConfig").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::offlineStoreConfig)).setter(DescribeFeatureGroupResponse.setter(Builder::offlineStoreConfig)).constructor(OfflineStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::roleArn)).setter(DescribeFeatureGroupResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupStatus").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::featureGroupStatusAsString)).setter(DescribeFeatureGroupResponse.setter(Builder::featureGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatus").build()}).build();
    private static final SdkField<OfflineStoreStatus> OFFLINE_STORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfflineStoreStatus").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::offlineStoreStatus)).setter(DescribeFeatureGroupResponse.setter(Builder::offlineStoreStatus)).constructor(OfflineStoreStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatus").build()}).build();
    private static final SdkField<LastUpdateStatus> LAST_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastUpdateStatus").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::lastUpdateStatus)).setter(DescribeFeatureGroupResponse.setter(Builder::lastUpdateStatus)).constructor(LastUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::failureReason)).setter(DescribeFeatureGroupResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::description)).setter(DescribeFeatureGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::nextToken)).setter(DescribeFeatureGroupResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> ONLINE_STORE_TOTAL_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OnlineStoreTotalSizeBytes").getter(DescribeFeatureGroupResponse.getter(DescribeFeatureGroupResponse::onlineStoreTotalSizeBytes)).setter(DescribeFeatureGroupResponse.setter(Builder::onlineStoreTotalSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreTotalSizeBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_ARN_FIELD, FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIER_FEATURE_NAME_FIELD, EVENT_TIME_FEATURE_NAME_FIELD, FEATURE_DEFINITIONS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ONLINE_STORE_CONFIG_FIELD, OFFLINE_STORE_CONFIG_FIELD, ROLE_ARN_FIELD, FEATURE_GROUP_STATUS_FIELD, OFFLINE_STORE_STATUS_FIELD, LAST_UPDATE_STATUS_FIELD, FAILURE_REASON_FIELD, DESCRIPTION_FIELD, NEXT_TOKEN_FIELD, ONLINE_STORE_TOTAL_SIZE_BYTES_FIELD));
    private final String featureGroupArn;
    private final String featureGroupName;
    private final String recordIdentifierFeatureName;
    private final String eventTimeFeatureName;
    private final List<FeatureDefinition> featureDefinitions;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final OnlineStoreConfig onlineStoreConfig;
    private final OfflineStoreConfig offlineStoreConfig;
    private final String roleArn;
    private final String featureGroupStatus;
    private final OfflineStoreStatus offlineStoreStatus;
    private final LastUpdateStatus lastUpdateStatus;
    private final String failureReason;
    private final String description;
    private final String nextToken;
    private final Long onlineStoreTotalSizeBytes;

    private DescribeFeatureGroupResponse(BuilderImpl builder) {
        super(builder);
        this.featureGroupArn = builder.featureGroupArn;
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierFeatureName = builder.recordIdentifierFeatureName;
        this.eventTimeFeatureName = builder.eventTimeFeatureName;
        this.featureDefinitions = builder.featureDefinitions;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.offlineStoreConfig = builder.offlineStoreConfig;
        this.roleArn = builder.roleArn;
        this.featureGroupStatus = builder.featureGroupStatus;
        this.offlineStoreStatus = builder.offlineStoreStatus;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.failureReason = builder.failureReason;
        this.description = builder.description;
        this.nextToken = builder.nextToken;
        this.onlineStoreTotalSizeBytes = builder.onlineStoreTotalSizeBytes;
    }

    public final String featureGroupArn() {
        return this.featureGroupArn;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String recordIdentifierFeatureName() {
        return this.recordIdentifierFeatureName;
    }

    public final String eventTimeFeatureName() {
        return this.eventTimeFeatureName;
    }

    public final boolean hasFeatureDefinitions() {
        return this.featureDefinitions != null && !(this.featureDefinitions instanceof SdkAutoConstructList);
    }

    public final List<FeatureDefinition> featureDefinitions() {
        return this.featureDefinitions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final OnlineStoreConfig onlineStoreConfig() {
        return this.onlineStoreConfig;
    }

    public final OfflineStoreConfig offlineStoreConfig() {
        return this.offlineStoreConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final FeatureGroupStatus featureGroupStatus() {
        return FeatureGroupStatus.fromValue(this.featureGroupStatus);
    }

    public final String featureGroupStatusAsString() {
        return this.featureGroupStatus;
    }

    public final OfflineStoreStatus offlineStoreStatus() {
        return this.offlineStoreStatus;
    }

    public final LastUpdateStatus lastUpdateStatus() {
        return this.lastUpdateStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String description() {
        return this.description;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long onlineStoreTotalSizeBytes() {
        return this.onlineStoreTotalSizeBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIdentifierFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureDefinitions() ? this.featureDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineStoreTotalSizeBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeatureGroupResponse)) {
            return false;
        }
        DescribeFeatureGroupResponse other = (DescribeFeatureGroupResponse)((Object)obj);
        return Objects.equals(this.featureGroupArn(), other.featureGroupArn()) && Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.recordIdentifierFeatureName(), other.recordIdentifierFeatureName()) && Objects.equals(this.eventTimeFeatureName(), other.eventTimeFeatureName()) && this.hasFeatureDefinitions() == other.hasFeatureDefinitions() && Objects.equals(this.featureDefinitions(), other.featureDefinitions()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.onlineStoreConfig(), other.onlineStoreConfig()) && Objects.equals(this.offlineStoreConfig(), other.offlineStoreConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.featureGroupStatusAsString(), other.featureGroupStatusAsString()) && Objects.equals(this.offlineStoreStatus(), other.offlineStoreStatus()) && Objects.equals(this.lastUpdateStatus(), other.lastUpdateStatus()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.onlineStoreTotalSizeBytes(), other.onlineStoreTotalSizeBytes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFeatureGroupResponse").add("FeatureGroupArn", (Object)this.featureGroupArn()).add("FeatureGroupName", (Object)this.featureGroupName()).add("RecordIdentifierFeatureName", (Object)this.recordIdentifierFeatureName()).add("EventTimeFeatureName", (Object)this.eventTimeFeatureName()).add("FeatureDefinitions", this.hasFeatureDefinitions() ? this.featureDefinitions() : null).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("OnlineStoreConfig", (Object)this.onlineStoreConfig()).add("OfflineStoreConfig", (Object)this.offlineStoreConfig()).add("RoleArn", (Object)this.roleArn()).add("FeatureGroupStatus", (Object)this.featureGroupStatusAsString()).add("OfflineStoreStatus", (Object)this.offlineStoreStatus()).add("LastUpdateStatus", (Object)this.lastUpdateStatus()).add("FailureReason", (Object)this.failureReason()).add("Description", (Object)this.description()).add("NextToken", (Object)this.nextToken()).add("OnlineStoreTotalSizeBytes", (Object)this.onlineStoreTotalSizeBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupArn": {
                return Optional.ofNullable(clazz.cast(this.featureGroupArn()));
            }
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "RecordIdentifierFeatureName": {
                return Optional.ofNullable(clazz.cast(this.recordIdentifierFeatureName()));
            }
            case "EventTimeFeatureName": {
                return Optional.ofNullable(clazz.cast(this.eventTimeFeatureName()));
            }
            case "FeatureDefinitions": {
                return Optional.ofNullable(clazz.cast(this.featureDefinitions()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "OnlineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.onlineStoreConfig()));
            }
            case "OfflineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "FeatureGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.featureGroupStatusAsString()));
            }
            case "OfflineStoreStatus": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreStatus()));
            }
            case "LastUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatus()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OnlineStoreTotalSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.onlineStoreTotalSizeBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeatureGroupResponse, T> g) {
        return obj -> g.apply((DescribeFeatureGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String featureGroupArn;
        private String featureGroupName;
        private String recordIdentifierFeatureName;
        private String eventTimeFeatureName;
        private List<FeatureDefinition> featureDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastModifiedTime;
        private OnlineStoreConfig onlineStoreConfig;
        private OfflineStoreConfig offlineStoreConfig;
        private String roleArn;
        private String featureGroupStatus;
        private OfflineStoreStatus offlineStoreStatus;
        private LastUpdateStatus lastUpdateStatus;
        private String failureReason;
        private String description;
        private String nextToken;
        private Long onlineStoreTotalSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeatureGroupResponse model) {
            super(model);
            this.featureGroupArn(model.featureGroupArn);
            this.featureGroupName(model.featureGroupName);
            this.recordIdentifierFeatureName(model.recordIdentifierFeatureName);
            this.eventTimeFeatureName(model.eventTimeFeatureName);
            this.featureDefinitions(model.featureDefinitions);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.onlineStoreConfig(model.onlineStoreConfig);
            this.offlineStoreConfig(model.offlineStoreConfig);
            this.roleArn(model.roleArn);
            this.featureGroupStatus(model.featureGroupStatus);
            this.offlineStoreStatus(model.offlineStoreStatus);
            this.lastUpdateStatus(model.lastUpdateStatus);
            this.failureReason(model.failureReason);
            this.description(model.description);
            this.nextToken(model.nextToken);
            this.onlineStoreTotalSizeBytes(model.onlineStoreTotalSizeBytes);
        }

        public final String getFeatureGroupArn() {
            return this.featureGroupArn;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        @Override
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierFeatureName() {
            return this.recordIdentifierFeatureName;
        }

        public final void setRecordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
        }

        @Override
        public final Builder recordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
            return this;
        }

        public final String getEventTimeFeatureName() {
            return this.eventTimeFeatureName;
        }

        public final void setEventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
        }

        @Override
        public final Builder eventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
            return this;
        }

        public final List<FeatureDefinition.Builder> getFeatureDefinitions() {
            List<FeatureDefinition.Builder> result = FeatureDefinitionsCopier.copyToBuilder(this.featureDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureDefinitions(Collection<FeatureDefinition.BuilderImpl> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copyFromBuilder(featureDefinitions);
        }

        @Override
        public final Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copy(featureDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(FeatureDefinition ... featureDefinitions) {
            this.featureDefinitions(Arrays.asList(featureDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(Consumer<FeatureDefinition.Builder> ... featureDefinitions) {
            this.featureDefinitions(Stream.of(featureDefinitions).map(c -> (FeatureDefinition)((FeatureDefinition.Builder)FeatureDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final OnlineStoreConfig.Builder getOnlineStoreConfig() {
            return this.onlineStoreConfig != null ? this.onlineStoreConfig.toBuilder() : null;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfig.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final OfflineStoreConfig.Builder getOfflineStoreConfig() {
            return this.offlineStoreConfig != null ? this.offlineStoreConfig.toBuilder() : null;
        }

        public final void setOfflineStoreConfig(OfflineStoreConfig.BuilderImpl offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig != null ? offlineStoreConfig.build() : null;
        }

        @Override
        public final Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFeatureGroupStatus() {
            return this.featureGroupStatus;
        }

        public final void setFeatureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
        }

        @Override
        public final Builder featureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
            return this;
        }

        @Override
        public final Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus) {
            this.featureGroupStatus(featureGroupStatus == null ? null : featureGroupStatus.toString());
            return this;
        }

        public final OfflineStoreStatus.Builder getOfflineStoreStatus() {
            return this.offlineStoreStatus != null ? this.offlineStoreStatus.toBuilder() : null;
        }

        public final void setOfflineStoreStatus(OfflineStoreStatus.BuilderImpl offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus != null ? offlineStoreStatus.build() : null;
        }

        @Override
        public final Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus;
            return this;
        }

        public final LastUpdateStatus.Builder getLastUpdateStatus() {
            return this.lastUpdateStatus != null ? this.lastUpdateStatus.toBuilder() : null;
        }

        public final void setLastUpdateStatus(LastUpdateStatus.BuilderImpl lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus != null ? lastUpdateStatus.build() : null;
        }

        @Override
        public final Builder lastUpdateStatus(LastUpdateStatus lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getOnlineStoreTotalSizeBytes() {
            return this.onlineStoreTotalSizeBytes;
        }

        public final void setOnlineStoreTotalSizeBytes(Long onlineStoreTotalSizeBytes) {
            this.onlineStoreTotalSizeBytes = onlineStoreTotalSizeBytes;
        }

        @Override
        public final Builder onlineStoreTotalSizeBytes(Long onlineStoreTotalSizeBytes) {
            this.onlineStoreTotalSizeBytes = onlineStoreTotalSizeBytes;
            return this;
        }

        @Override
        public DescribeFeatureGroupResponse build() {
            return new DescribeFeatureGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFeatureGroupResponse> {
        public Builder featureGroupArn(String var1);

        public Builder featureGroupName(String var1);

        public Builder recordIdentifierFeatureName(String var1);

        public Builder eventTimeFeatureName(String var1);

        public Builder featureDefinitions(Collection<FeatureDefinition> var1);

        public Builder featureDefinitions(FeatureDefinition ... var1);

        public Builder featureDefinitions(Consumer<FeatureDefinition.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder onlineStoreConfig(OnlineStoreConfig var1);

        default public Builder onlineStoreConfig(Consumer<OnlineStoreConfig.Builder> onlineStoreConfig) {
            return this.onlineStoreConfig((OnlineStoreConfig)((OnlineStoreConfig.Builder)OnlineStoreConfig.builder().applyMutation(onlineStoreConfig)).build());
        }

        public Builder offlineStoreConfig(OfflineStoreConfig var1);

        default public Builder offlineStoreConfig(Consumer<OfflineStoreConfig.Builder> offlineStoreConfig) {
            return this.offlineStoreConfig((OfflineStoreConfig)((OfflineStoreConfig.Builder)OfflineStoreConfig.builder().applyMutation(offlineStoreConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder featureGroupStatus(String var1);

        public Builder featureGroupStatus(FeatureGroupStatus var1);

        public Builder offlineStoreStatus(OfflineStoreStatus var1);

        default public Builder offlineStoreStatus(Consumer<OfflineStoreStatus.Builder> offlineStoreStatus) {
            return this.offlineStoreStatus((OfflineStoreStatus)((OfflineStoreStatus.Builder)OfflineStoreStatus.builder().applyMutation(offlineStoreStatus)).build());
        }

        public Builder lastUpdateStatus(LastUpdateStatus var1);

        default public Builder lastUpdateStatus(Consumer<LastUpdateStatus.Builder> lastUpdateStatus) {
            return this.lastUpdateStatus((LastUpdateStatus)((LastUpdateStatus.Builder)LastUpdateStatus.builder().applyMutation(lastUpdateStatus)).build());
        }

        public Builder failureReason(String var1);

        public Builder description(String var1);

        public Builder nextToken(String var1);

        public Builder onlineStoreTotalSizeBytes(Long var1);
    }
}

