/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;

public class ListWorkteamsPublisher
implements SdkPublisher<ListWorkteamsResponse> {
    private final SageMakerAsyncClient client;
    private final ListWorkteamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkteamsPublisher(SageMakerAsyncClient client, ListWorkteamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkteamsPublisher(SageMakerAsyncClient client, ListWorkteamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkteamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkteamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListWorkteamsPublisher resume(ListWorkteamsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListWorkteamsPublisher(this.client, (ListWorkteamsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListWorkteamsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListWorkteamsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListWorkteamsResponseFetcher
    implements AsyncPageFetcher<ListWorkteamsResponse> {
        private ListWorkteamsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkteamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkteamsResponse> nextPage(ListWorkteamsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkteamsPublisher.this.client.listWorkteams(ListWorkteamsPublisher.this.firstRequest);
            }
            return ListWorkteamsPublisher.this.client.listWorkteams((ListWorkteamsRequest)((Object)ListWorkteamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

