/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.BatchTransformInput;
import software.amazon.awssdk.services.sagemaker.model.EndpointInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringInput> {
    private static final SdkField<EndpointInput> ENDPOINT_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointInput").getter(MonitoringInput.getter(MonitoringInput::endpointInput)).setter(MonitoringInput.setter(Builder::endpointInput)).constructor(EndpointInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInput").build()}).build();
    private static final SdkField<BatchTransformInput> BATCH_TRANSFORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BatchTransformInput").getter(MonitoringInput.getter(MonitoringInput::batchTransformInput)).setter(MonitoringInput.setter(Builder::batchTransformInput)).constructor(BatchTransformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchTransformInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_INPUT_FIELD, BATCH_TRANSFORM_INPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final EndpointInput endpointInput;
    private final BatchTransformInput batchTransformInput;

    private MonitoringInput(BuilderImpl builder) {
        this.endpointInput = builder.endpointInput;
        this.batchTransformInput = builder.batchTransformInput;
    }

    public final EndpointInput endpointInput() {
        return this.endpointInput;
    }

    public final BatchTransformInput batchTransformInput() {
        return this.batchTransformInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchTransformInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringInput)) {
            return false;
        }
        MonitoringInput other = (MonitoringInput)obj;
        return Objects.equals(this.endpointInput(), other.endpointInput()) && Objects.equals(this.batchTransformInput(), other.batchTransformInput());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringInput").add("EndpointInput", (Object)this.endpointInput()).add("BatchTransformInput", (Object)this.batchTransformInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointInput": {
                return Optional.ofNullable(clazz.cast(this.endpointInput()));
            }
            case "BatchTransformInput": {
                return Optional.ofNullable(clazz.cast(this.batchTransformInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringInput, T> g) {
        return obj -> g.apply((MonitoringInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EndpointInput endpointInput;
        private BatchTransformInput batchTransformInput;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringInput model) {
            this.endpointInput(model.endpointInput);
            this.batchTransformInput(model.batchTransformInput);
        }

        public final EndpointInput.Builder getEndpointInput() {
            return this.endpointInput != null ? this.endpointInput.toBuilder() : null;
        }

        public final void setEndpointInput(EndpointInput.BuilderImpl endpointInput) {
            this.endpointInput = endpointInput != null ? endpointInput.build() : null;
        }

        @Override
        public final Builder endpointInput(EndpointInput endpointInput) {
            this.endpointInput = endpointInput;
            return this;
        }

        public final BatchTransformInput.Builder getBatchTransformInput() {
            return this.batchTransformInput != null ? this.batchTransformInput.toBuilder() : null;
        }

        public final void setBatchTransformInput(BatchTransformInput.BuilderImpl batchTransformInput) {
            this.batchTransformInput = batchTransformInput != null ? batchTransformInput.build() : null;
        }

        @Override
        public final Builder batchTransformInput(BatchTransformInput batchTransformInput) {
            this.batchTransformInput = batchTransformInput;
            return this;
        }

        public MonitoringInput build() {
            return new MonitoringInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringInput> {
        public Builder endpointInput(EndpointInput var1);

        default public Builder endpointInput(Consumer<EndpointInput.Builder> endpointInput) {
            return this.endpointInput((EndpointInput)((EndpointInput.Builder)EndpointInput.builder().applyMutation(endpointInput)).build());
        }

        public Builder batchTransformInput(BatchTransformInput var1);

        default public Builder batchTransformInput(Consumer<BatchTransformInput.Builder> batchTransformInput) {
            return this.batchTransformInput((BatchTransformInput)((BatchTransformInput.Builder)BatchTransformInput.builder().applyMutation(batchTransformInput)).build());
        }
    }
}

