/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClarifyFeatureType {
    NUMERICAL("numerical"),
    CATEGORICAL("categorical"),
    TEXT("text"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClarifyFeatureType> VALUE_MAP;
    private final String value;

    private ClarifyFeatureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClarifyFeatureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClarifyFeatureType> knownValues() {
        EnumSet<ClarifyFeatureType> knownValues = EnumSet.allOf(ClarifyFeatureType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClarifyFeatureType.class, ClarifyFeatureType::toString);
    }
}

