/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;

public class ListFlowDefinitionsPublisher
implements SdkPublisher<ListFlowDefinitionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListFlowDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowDefinitionsPublisher(SageMakerAsyncClient client, ListFlowDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowDefinitionsPublisher(SageMakerAsyncClient client, ListFlowDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowDefinitionSummary> flowDefinitionSummaries() {
        Function<ListFlowDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowDefinitionSummaries() != null) {
                return response.flowDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListFlowDefinitionsResponse> {
        private ListFlowDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowDefinitionsResponse> nextPage(ListFlowDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowDefinitionsPublisher.this.client.listFlowDefinitions(ListFlowDefinitionsPublisher.this.firstRequest);
            }
            return ListFlowDefinitionsPublisher.this.client.listFlowDefinitions((ListFlowDefinitionsRequest)((Object)ListFlowDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

