/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;

public class ListEdgePackagingJobsIterable
implements SdkIterable<ListEdgePackagingJobsResponse> {
    private final SageMakerClient client;
    private final ListEdgePackagingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEdgePackagingJobsIterable(SageMakerClient client, ListEdgePackagingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEdgePackagingJobsResponseFetcher();
    }

    public Iterator<ListEdgePackagingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EdgePackagingJobSummary> edgePackagingJobSummaries() {
        Function<ListEdgePackagingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.edgePackagingJobSummaries() != null) {
                return response.edgePackagingJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEdgePackagingJobsResponseFetcher
    implements SyncPageFetcher<ListEdgePackagingJobsResponse> {
        private ListEdgePackagingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEdgePackagingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEdgePackagingJobsResponse nextPage(ListEdgePackagingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEdgePackagingJobsIterable.this.client.listEdgePackagingJobs(ListEdgePackagingJobsIterable.this.firstRequest);
            }
            return ListEdgePackagingJobsIterable.this.client.listEdgePackagingJobs((ListEdgePackagingJobsRequest)((Object)ListEdgePackagingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

