/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelApprovalStatus {
    APPROVED("Approved"),
    REJECTED("Rejected"),
    PENDING_MANUAL_APPROVAL("PendingManualApproval"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelApprovalStatus> VALUE_MAP;
    private final String value;

    private ModelApprovalStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelApprovalStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelApprovalStatus> knownValues() {
        EnumSet<ModelApprovalStatus> knownValues = EnumSet.allOf(ModelApprovalStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelApprovalStatus.class, ModelApprovalStatus::toString);
    }
}

