/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortBy;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingJobsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListTrainingJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::nextToken)).setter(ListTrainingJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::maxResults)).setter(ListTrainingJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::creationTimeAfter)).setter(ListTrainingJobsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::creationTimeBefore)).setter(ListTrainingJobsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeAfter").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::lastModifiedTimeAfter)).setter(ListTrainingJobsRequest.setter(Builder::lastModifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeBefore").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::lastModifiedTimeBefore)).setter(ListTrainingJobsRequest.setter(Builder::lastModifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build()}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::nameContains)).setter(ListTrainingJobsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusEquals").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::statusEqualsAsString)).setter(ListTrainingJobsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::sortByAsString)).setter(ListTrainingJobsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::sortOrderAsString)).setter(ListTrainingJobsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> WARM_POOL_STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarmPoolStatusEquals").getter(ListTrainingJobsRequest.getter(ListTrainingJobsRequest::warmPoolStatusEqualsAsString)).setter(ListTrainingJobsRequest.setter(Builder::warmPoolStatusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolStatusEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, WARM_POOL_STATUS_EQUALS_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final Instant lastModifiedTimeAfter;
    private final Instant lastModifiedTimeBefore;
    private final String nameContains;
    private final String statusEquals;
    private final String sortBy;
    private final String sortOrder;
    private final String warmPoolStatusEquals;

    private ListTrainingJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.nameContains = builder.nameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.warmPoolStatusEquals = builder.warmPoolStatusEquals;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final Instant lastModifiedTimeAfter() {
        return this.lastModifiedTimeAfter;
    }

    public final Instant lastModifiedTimeBefore() {
        return this.lastModifiedTimeBefore;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final TrainingJobStatus statusEquals() {
        return TrainingJobStatus.fromValue(this.statusEquals);
    }

    public final String statusEqualsAsString() {
        return this.statusEquals;
    }

    public final SortBy sortBy() {
        return SortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final WarmPoolResourceStatus warmPoolStatusEquals() {
        return WarmPoolResourceStatus.fromValue(this.warmPoolStatusEquals);
    }

    public final String warmPoolStatusEqualsAsString() {
        return this.warmPoolStatusEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmPoolStatusEqualsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsRequest)) {
            return false;
        }
        ListTrainingJobsRequest other = (ListTrainingJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.lastModifiedTimeAfter(), other.lastModifiedTimeAfter()) && Objects.equals(this.lastModifiedTimeBefore(), other.lastModifiedTimeBefore()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.warmPoolStatusEqualsAsString(), other.warmPoolStatusEqualsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainingJobsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("LastModifiedTimeAfter", (Object)this.lastModifiedTimeAfter()).add("LastModifiedTimeBefore", (Object)this.lastModifiedTimeBefore()).add("NameContains", (Object)this.nameContains()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("WarmPoolStatusEquals", (Object)this.warmPoolStatusEqualsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "LastModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeAfter()));
            }
            case "LastModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeBefore()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "WarmPoolStatusEquals": {
                return Optional.ofNullable(clazz.cast(this.warmPoolStatusEqualsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsRequest, T> g) {
        return obj -> g.apply((ListTrainingJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private Instant lastModifiedTimeAfter;
        private Instant lastModifiedTimeBefore;
        private String nameContains;
        private String statusEquals;
        private String sortBy;
        private String sortOrder;
        private String warmPoolStatusEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            this.lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            this.nameContains(model.nameContains);
            this.statusEquals(model.statusEquals);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.warmPoolStatusEquals(model.warmPoolStatusEquals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return this.lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return this.lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(TrainingJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getWarmPoolStatusEquals() {
            return this.warmPoolStatusEquals;
        }

        public final void setWarmPoolStatusEquals(String warmPoolStatusEquals) {
            this.warmPoolStatusEquals = warmPoolStatusEquals;
        }

        @Override
        public final Builder warmPoolStatusEquals(String warmPoolStatusEquals) {
            this.warmPoolStatusEquals = warmPoolStatusEquals;
            return this;
        }

        @Override
        public final Builder warmPoolStatusEquals(WarmPoolResourceStatus warmPoolStatusEquals) {
            this.warmPoolStatusEquals(warmPoolStatusEquals == null ? null : warmPoolStatusEquals.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrainingJobsRequest build() {
            return new ListTrainingJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingJobsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder lastModifiedTimeAfter(Instant var1);

        public Builder lastModifiedTimeBefore(Instant var1);

        public Builder nameContains(String var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(TrainingJobStatus var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder warmPoolStatusEquals(String var1);

        public Builder warmPoolStatusEquals(WarmPoolResourceStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

