/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLMetricExtendedEnum {
    ACCURACY("Accuracy"),
    MSE("MSE"),
    F1("F1"),
    F1_MACRO("F1macro"),
    AUC("AUC"),
    RMSE("RMSE"),
    MAE("MAE"),
    R2("R2"),
    BALANCED_ACCURACY("BalancedAccuracy"),
    PRECISION("Precision"),
    PRECISION_MACRO("PrecisionMacro"),
    RECALL("Recall"),
    RECALL_MACRO("RecallMacro"),
    LOG_LOSS("LogLoss"),
    INFERENCE_LATENCY("InferenceLatency"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLMetricExtendedEnum> VALUE_MAP;
    private final String value;

    private AutoMLMetricExtendedEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLMetricExtendedEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLMetricExtendedEnum> knownValues() {
        EnumSet<AutoMLMetricExtendedEnum> knownValues = EnumSet.allOf(AutoMLMetricExtendedEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLMetricExtendedEnum.class, AutoMLMetricExtendedEnum::toString);
    }
}

