/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobPayloadConfig;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedInstanceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationJobContainerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationJobContainerConfig> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::domain)).setter(RecommendationJobContainerConfig.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Task").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::task)).setter(RecommendationJobContainerConfig.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Framework").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::framework)).setter(RecommendationJobContainerConfig.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkVersion").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::frameworkVersion)).setter(RecommendationJobContainerConfig.setter(Builder::frameworkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()}).build();
    private static final SdkField<RecommendationJobPayloadConfig> PAYLOAD_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PayloadConfig").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::payloadConfig)).setter(RecommendationJobContainerConfig.setter(Builder::payloadConfig)).constructor(RecommendationJobPayloadConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadConfig").build()}).build();
    private static final SdkField<String> NEAREST_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NearestModelName").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::nearestModelName)).setter(RecommendationJobContainerConfig.setter(Builder::nearestModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NearestModelName").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedInstanceTypes").getter(RecommendationJobContainerConfig.getter(RecommendationJobContainerConfig::supportedInstanceTypes)).setter(RecommendationJobContainerConfig.setter(Builder::supportedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, TASK_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, PAYLOAD_CONFIG_FIELD, NEAREST_MODEL_NAME_FIELD, SUPPORTED_INSTANCE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String task;
    private final String framework;
    private final String frameworkVersion;
    private final RecommendationJobPayloadConfig payloadConfig;
    private final String nearestModelName;
    private final List<String> supportedInstanceTypes;

    private RecommendationJobContainerConfig(BuilderImpl builder) {
        this.domain = builder.domain;
        this.task = builder.task;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.payloadConfig = builder.payloadConfig;
        this.nearestModelName = builder.nearestModelName;
        this.supportedInstanceTypes = builder.supportedInstanceTypes;
    }

    public final String domain() {
        return this.domain;
    }

    public final String task() {
        return this.task;
    }

    public final String framework() {
        return this.framework;
    }

    public final String frameworkVersion() {
        return this.frameworkVersion;
    }

    public final RecommendationJobPayloadConfig payloadConfig() {
        return this.payloadConfig;
    }

    public final String nearestModelName() {
        return this.nearestModelName;
    }

    public final boolean hasSupportedInstanceTypes() {
        return this.supportedInstanceTypes != null && !(this.supportedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedInstanceTypes() {
        return this.supportedInstanceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.nearestModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedInstanceTypes() ? this.supportedInstanceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobContainerConfig)) {
            return false;
        }
        RecommendationJobContainerConfig other = (RecommendationJobContainerConfig)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.framework(), other.framework()) && Objects.equals(this.frameworkVersion(), other.frameworkVersion()) && Objects.equals(this.payloadConfig(), other.payloadConfig()) && Objects.equals(this.nearestModelName(), other.nearestModelName()) && this.hasSupportedInstanceTypes() == other.hasSupportedInstanceTypes() && Objects.equals(this.supportedInstanceTypes(), other.supportedInstanceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationJobContainerConfig").add("Domain", (Object)this.domain()).add("Task", (Object)this.task()).add("Framework", (Object)this.framework()).add("FrameworkVersion", (Object)this.frameworkVersion()).add("PayloadConfig", (Object)this.payloadConfig()).add("NearestModelName", (Object)this.nearestModelName()).add("SupportedInstanceTypes", this.hasSupportedInstanceTypes() ? this.supportedInstanceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "FrameworkVersion": {
                return Optional.ofNullable(clazz.cast(this.frameworkVersion()));
            }
            case "PayloadConfig": {
                return Optional.ofNullable(clazz.cast(this.payloadConfig()));
            }
            case "NearestModelName": {
                return Optional.ofNullable(clazz.cast(this.nearestModelName()));
            }
            case "SupportedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedInstanceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobContainerConfig, T> g) {
        return obj -> g.apply((RecommendationJobContainerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String task;
        private String framework;
        private String frameworkVersion;
        private RecommendationJobPayloadConfig payloadConfig;
        private String nearestModelName;
        private List<String> supportedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobContainerConfig model) {
            this.domain(model.domain);
            this.task(model.task);
            this.framework(model.framework);
            this.frameworkVersion(model.frameworkVersion);
            this.payloadConfig(model.payloadConfig);
            this.nearestModelName(model.nearestModelName);
            this.supportedInstanceTypes(model.supportedInstanceTypes);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getTask() {
            return this.task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getFramework() {
            return this.framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getFrameworkVersion() {
            return this.frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final RecommendationJobPayloadConfig.Builder getPayloadConfig() {
            return this.payloadConfig != null ? this.payloadConfig.toBuilder() : null;
        }

        public final void setPayloadConfig(RecommendationJobPayloadConfig.BuilderImpl payloadConfig) {
            this.payloadConfig = payloadConfig != null ? payloadConfig.build() : null;
        }

        @Override
        public final Builder payloadConfig(RecommendationJobPayloadConfig payloadConfig) {
            this.payloadConfig = payloadConfig;
            return this;
        }

        public final String getNearestModelName() {
            return this.nearestModelName;
        }

        public final void setNearestModelName(String nearestModelName) {
            this.nearestModelName = nearestModelName;
        }

        @Override
        public final Builder nearestModelName(String nearestModelName) {
            this.nearestModelName = nearestModelName;
            return this;
        }

        public final Collection<String> getSupportedInstanceTypes() {
            if (this.supportedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedInstanceTypes;
        }

        public final void setSupportedInstanceTypes(Collection<String> supportedInstanceTypes) {
            this.supportedInstanceTypes = RecommendationJobSupportedInstanceTypesCopier.copy(supportedInstanceTypes);
        }

        @Override
        public final Builder supportedInstanceTypes(Collection<String> supportedInstanceTypes) {
            this.supportedInstanceTypes = RecommendationJobSupportedInstanceTypesCopier.copy(supportedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceTypes(String ... supportedInstanceTypes) {
            this.supportedInstanceTypes(Arrays.asList(supportedInstanceTypes));
            return this;
        }

        public RecommendationJobContainerConfig build() {
            return new RecommendationJobContainerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationJobContainerConfig> {
        public Builder domain(String var1);

        public Builder task(String var1);

        public Builder framework(String var1);

        public Builder frameworkVersion(String var1);

        public Builder payloadConfig(RecommendationJobPayloadConfig var1);

        default public Builder payloadConfig(Consumer<RecommendationJobPayloadConfig.Builder> payloadConfig) {
            return this.payloadConfig((RecommendationJobPayloadConfig)((RecommendationJobPayloadConfig.Builder)RecommendationJobPayloadConfig.builder().applyMutation(payloadConfig)).build());
        }

        public Builder nearestModelName(String var1);

        public Builder supportedInstanceTypes(Collection<String> var1);

        public Builder supportedInstanceTypes(String ... var1);
    }
}

