/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppImageConfigDetails;
import software.amazon.awssdk.services.sagemaker.model.AppImageConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppImageConfigsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListAppImageConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppImageConfigsResponse.getter(ListAppImageConfigsResponse::nextToken)).setter(ListAppImageConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<AppImageConfigDetails>> APP_IMAGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppImageConfigs").getter(ListAppImageConfigsResponse.getter(ListAppImageConfigsResponse::appImageConfigs)).setter(ListAppImageConfigsResponse.setter(Builder::appImageConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppImageConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, APP_IMAGE_CONFIGS_FIELD));
    private final String nextToken;
    private final List<AppImageConfigDetails> appImageConfigs;

    private ListAppImageConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.appImageConfigs = builder.appImageConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAppImageConfigs() {
        return this.appImageConfigs != null && !(this.appImageConfigs instanceof SdkAutoConstructList);
    }

    public final List<AppImageConfigDetails> appImageConfigs() {
        return this.appImageConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppImageConfigs() ? this.appImageConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppImageConfigsResponse)) {
            return false;
        }
        ListAppImageConfigsResponse other = (ListAppImageConfigsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAppImageConfigs() == other.hasAppImageConfigs() && Objects.equals(this.appImageConfigs(), other.appImageConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppImageConfigsResponse").add("NextToken", (Object)this.nextToken()).add("AppImageConfigs", this.hasAppImageConfigs() ? this.appImageConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AppImageConfigs": {
                return Optional.ofNullable(clazz.cast(this.appImageConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppImageConfigsResponse, T> g) {
        return obj -> g.apply((ListAppImageConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AppImageConfigDetails> appImageConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppImageConfigsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.appImageConfigs(model.appImageConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AppImageConfigDetails.Builder> getAppImageConfigs() {
            List<AppImageConfigDetails.Builder> result = AppImageConfigListCopier.copyToBuilder(this.appImageConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppImageConfigs(Collection<AppImageConfigDetails.BuilderImpl> appImageConfigs) {
            this.appImageConfigs = AppImageConfigListCopier.copyFromBuilder(appImageConfigs);
        }

        @Override
        @Transient
        public final Builder appImageConfigs(Collection<AppImageConfigDetails> appImageConfigs) {
            this.appImageConfigs = AppImageConfigListCopier.copy(appImageConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appImageConfigs(AppImageConfigDetails ... appImageConfigs) {
            this.appImageConfigs(Arrays.asList(appImageConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appImageConfigs(Consumer<AppImageConfigDetails.Builder> ... appImageConfigs) {
            this.appImageConfigs(Stream.of(appImageConfigs).map(c -> (AppImageConfigDetails)((AppImageConfigDetails.Builder)AppImageConfigDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAppImageConfigsResponse build() {
            return new ListAppImageConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppImageConfigsResponse> {
        public Builder nextToken(String var1);

        public Builder appImageConfigs(Collection<AppImageConfigDetails> var1);

        public Builder appImageConfigs(AppImageConfigDetails ... var1);

        public Builder appImageConfigs(Consumer<AppImageConfigDetails.Builder> ... var1);
    }
}

