/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.MetadataProperties;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelMetrics;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelPackageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageName").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageName)).setter(CreateModelPackageRequest.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageGroupName)).setter(CreateModelPackageRequest.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageDescription").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageDescription)).setter(CreateModelPackageRequest.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::inferenceSpecification)).setter(CreateModelPackageRequest.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::validationSpecification)).setter(CreateModelPackageRequest.setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceAlgorithmSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::sourceAlgorithmSpecification)).setter(CreateModelPackageRequest.setter(Builder::sourceAlgorithmSpecification)).constructor(SourceAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertifyForMarketplace").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::certifyForMarketplace)).setter(CreateModelPackageRequest.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::tags)).setter(CreateModelPackageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelApprovalStatusAsString)).setter(CreateModelPackageRequest.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataProperties").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::metadataProperties)).setter(CreateModelPackageRequest.setter(Builder::metadataProperties)).constructor(MetadataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build()}).build();
    private static final SdkField<ModelMetrics> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelMetrics").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelMetrics)).setter(CreateModelPackageRequest.setter(Builder::modelMetrics)).constructor(ModelMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::clientToken)).setter(CreateModelPackageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, SOURCE_ALGORITHM_SPECIFICATION_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD, TAGS_FIELD, MODEL_APPROVAL_STATUS_FIELD, METADATA_PROPERTIES_FIELD, MODEL_METRICS_FIELD, CLIENT_TOKEN_FIELD));
    private final String modelPackageName;
    private final String modelPackageGroupName;
    private final String modelPackageDescription;
    private final InferenceSpecification inferenceSpecification;
    private final ModelPackageValidationSpecification validationSpecification;
    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;
    private final Boolean certifyForMarketplace;
    private final List<Tag> tags;
    private final String modelApprovalStatus;
    private final MetadataProperties metadataProperties;
    private final ModelMetrics modelMetrics;
    private final String clientToken;

    private CreateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.certifyForMarketplace = builder.certifyForMarketplace;
        this.tags = builder.tags;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.metadataProperties = builder.metadataProperties;
        this.modelMetrics = builder.modelMetrics;
        this.clientToken = builder.clientToken;
    }

    public final String modelPackageName() {
        return this.modelPackageName;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public final InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public final ModelPackageValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public final SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return this.sourceAlgorithmSpecification;
    }

    public final Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public final MetadataProperties metadataProperties() {
        return this.metadataProperties;
    }

    public final ModelMetrics modelMetrics() {
        return this.modelMetrics;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelPackageRequest)) {
            return false;
        }
        CreateModelPackageRequest other = (CreateModelPackageRequest)((Object)obj);
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString()) && Objects.equals(this.metadataProperties(), other.metadataProperties()) && Objects.equals(this.modelMetrics(), other.modelMetrics()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelPackageRequest").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("SourceAlgorithmSpecification", (Object)this.sourceAlgorithmSpecification()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).add("Tags", this.hasTags() ? this.tags() : null).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).add("MetadataProperties", (Object)this.metadataProperties()).add("ModelMetrics", (Object)this.modelMetrics()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "SourceAlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.sourceAlgorithmSpecification()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
            case "MetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.metadataProperties()));
            }
            case "ModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelPackageRequest, T> g) {
        return obj -> g.apply((CreateModelPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageGroupName;
        private String modelPackageDescription;
        private InferenceSpecification inferenceSpecification;
        private ModelPackageValidationSpecification validationSpecification;
        private SourceAlgorithmSpecification sourceAlgorithmSpecification;
        private Boolean certifyForMarketplace;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String modelApprovalStatus;
        private MetadataProperties metadataProperties;
        private ModelMetrics modelMetrics;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelPackageRequest model) {
            super(model);
            this.modelPackageName(model.modelPackageName);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.modelPackageDescription(model.modelPackageDescription);
            this.inferenceSpecification(model.inferenceSpecification);
            this.validationSpecification(model.validationSpecification);
            this.sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            this.certifyForMarketplace(model.certifyForMarketplace);
            this.tags(model.tags);
            this.modelApprovalStatus(model.modelApprovalStatus);
            this.metadataProperties(model.metadataProperties);
            this.modelMetrics(model.modelMetrics);
            this.clientToken(model.clientToken);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        @Transient
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        @Transient
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        @Override
        @Transient
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return this.sourceAlgorithmSpecification != null ? this.sourceAlgorithmSpecification.toBuilder() : null;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        @Transient
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        @Transient
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return this.metadataProperties != null ? this.metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final ModelMetrics.Builder getModelMetrics() {
            return this.modelMetrics != null ? this.modelMetrics.toBuilder() : null;
        }

        public final void setModelMetrics(ModelMetrics.BuilderImpl modelMetrics) {
            this.modelMetrics = modelMetrics != null ? modelMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder modelMetrics(ModelMetrics modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelPackageRequest build() {
            return new CreateModelPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelPackageRequest> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageGroupName(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder validationSpecification(ModelPackageValidationSpecification var1);

        default public Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((ModelPackageValidationSpecification)((ModelPackageValidationSpecification.Builder)ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification var1);

        default public Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return this.sourceAlgorithmSpecification((SourceAlgorithmSpecification)((SourceAlgorithmSpecification.Builder)SourceAlgorithmSpecification.builder().applyMutation(sourceAlgorithmSpecification)).build());
        }

        public Builder certifyForMarketplace(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);

        public Builder metadataProperties(MetadataProperties var1);

        default public Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return this.metadataProperties((MetadataProperties)((MetadataProperties.Builder)MetadataProperties.builder().applyMutation(metadataProperties)).build());
        }

        public Builder modelMetrics(ModelMetrics var1);

        default public Builder modelMetrics(Consumer<ModelMetrics.Builder> modelMetrics) {
            return this.modelMetrics((ModelMetrics)((ModelMetrics.Builder)ModelMetrics.builder().applyMutation(modelMetrics)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

