/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AssemblyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformOutput> {
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(TransformOutput.getter(TransformOutput::s3OutputPath)).setter(TransformOutput.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Accept").getter(TransformOutput.getter(TransformOutput::accept)).setter(TransformOutput.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accept").build()}).build();
    private static final SdkField<String> ASSEMBLE_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssembleWith").getter(TransformOutput.getter(TransformOutput::assembleWithAsString)).setter(TransformOutput.setter(Builder::assembleWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssembleWith").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(TransformOutput.getter(TransformOutput::kmsKeyId)).setter(TransformOutput.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_PATH_FIELD, ACCEPT_FIELD, ASSEMBLE_WITH_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3OutputPath;
    private final String accept;
    private final String assembleWith;
    private final String kmsKeyId;

    private TransformOutput(BuilderImpl builder) {
        this.s3OutputPath = builder.s3OutputPath;
        this.accept = builder.accept;
        this.assembleWith = builder.assembleWith;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final String accept() {
        return this.accept;
    }

    public final AssemblyType assembleWith() {
        return AssemblyType.fromValue(this.assembleWith);
    }

    public final String assembleWithAsString() {
        return this.assembleWith;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.assembleWithAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOutput)) {
            return false;
        }
        TransformOutput other = (TransformOutput)obj;
        return Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.assembleWithAsString(), other.assembleWithAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"TransformOutput").add("S3OutputPath", (Object)this.s3OutputPath()).add("Accept", (Object)this.accept()).add("AssembleWith", (Object)this.assembleWithAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "Accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "AssembleWith": {
                return Optional.ofNullable(clazz.cast(this.assembleWithAsString()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformOutput, T> g) {
        return obj -> g.apply((TransformOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputPath;
        private String accept;
        private String assembleWith;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOutput model) {
            this.s3OutputPath(model.s3OutputPath);
            this.accept(model.accept);
            this.assembleWith(model.assembleWith);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        @Transient
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        @Transient
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getAssembleWith() {
            return this.assembleWith;
        }

        public final void setAssembleWith(String assembleWith) {
            this.assembleWith = assembleWith;
        }

        @Override
        @Transient
        public final Builder assembleWith(String assembleWith) {
            this.assembleWith = assembleWith;
            return this;
        }

        @Override
        @Transient
        public final Builder assembleWith(AssemblyType assembleWith) {
            this.assembleWith(assembleWith == null ? null : assembleWith.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public TransformOutput build() {
            return new TransformOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformOutput> {
        public Builder s3OutputPath(String var1);

        public Builder accept(String var1);

        public Builder assembleWith(String var1);

        public Builder assembleWith(AssemblyType var1);

        public Builder kmsKeyId(String var1);
    }
}

