/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    TRAINING_JOB("TrainingJob"),
    EXPERIMENT("Experiment"),
    EXPERIMENT_TRIAL("ExperimentTrial"),
    EXPERIMENT_TRIAL_COMPONENT("ExperimentTrialComponent"),
    ENDPOINT("Endpoint"),
    MODEL_PACKAGE("ModelPackage"),
    MODEL_PACKAGE_GROUP("ModelPackageGroup"),
    PIPELINE("Pipeline"),
    PIPELINE_EXECUTION("PipelineExecution"),
    FEATURE_GROUP("FeatureGroup"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

