/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary;

public class ListModelMetadataPublisher
implements SdkPublisher<ListModelMetadataResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelMetadataPublisher(SageMakerAsyncClient client, ListModelMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelMetadataPublisher(SageMakerAsyncClient client, ListModelMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelMetadataSummary> modelMetadataSummaries() {
        Function<ListModelMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelMetadataSummaries() != null) {
                return response.modelMetadataSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelMetadataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelMetadataResponseFetcher
    implements AsyncPageFetcher<ListModelMetadataResponse> {
        private ListModelMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListModelMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelMetadataResponse> nextPage(ListModelMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListModelMetadataPublisher.this.client.listModelMetadata(ListModelMetadataPublisher.this.firstRequest);
            }
            return ListModelMetadataPublisher.this.client.listModelMetadata((ListModelMetadataRequest)((Object)ListModelMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

