/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Direction {
    BOTH("Both"),
    ASCENDANTS("Ascendants"),
    DESCENDANTS("Descendants"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Direction> VALUE_MAP;
    private final String value;

    private Direction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Direction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Direction> knownValues() {
        EnumSet<Direction> knownValues = EnumSet.allOf(Direction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Direction.class, Direction::toString);
    }
}

