/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeModel> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(EdgeModel.getter(EdgeModel::modelName)).setter(EdgeModel.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(EdgeModel.getter(EdgeModel::modelVersion)).setter(EdgeModel.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<Instant> LATEST_SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestSampleTime").getter(EdgeModel.getter(EdgeModel::latestSampleTime)).setter(EdgeModel.setter(Builder::latestSampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSampleTime").build()}).build();
    private static final SdkField<Instant> LATEST_INFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestInference").getter(EdgeModel.getter(EdgeModel::latestInference)).setter(EdgeModel.setter(Builder::latestInference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_VERSION_FIELD, LATEST_SAMPLE_TIME_FIELD, LATEST_INFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelVersion;
    private final Instant latestSampleTime;
    private final Instant latestInference;

    private EdgeModel(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.latestSampleTime = builder.latestSampleTime;
        this.latestInference = builder.latestInference;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final Instant latestSampleTime() {
        return this.latestSampleTime;
    }

    public final Instant latestInference() {
        return this.latestInference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestInference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeModel)) {
            return false;
        }
        EdgeModel other = (EdgeModel)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.latestSampleTime(), other.latestSampleTime()) && Objects.equals(this.latestInference(), other.latestInference());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeModel").add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("LatestSampleTime", (Object)this.latestSampleTime()).add("LatestInference", (Object)this.latestInference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "LatestSampleTime": {
                return Optional.ofNullable(clazz.cast(this.latestSampleTime()));
            }
            case "LatestInference": {
                return Optional.ofNullable(clazz.cast(this.latestInference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeModel, T> g) {
        return obj -> g.apply((EdgeModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelVersion;
        private Instant latestSampleTime;
        private Instant latestInference;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeModel model) {
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.latestSampleTime(model.latestSampleTime);
            this.latestInference(model.latestInference);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Instant getLatestSampleTime() {
            return this.latestSampleTime;
        }

        public final void setLatestSampleTime(Instant latestSampleTime) {
            this.latestSampleTime = latestSampleTime;
        }

        @Override
        @Transient
        public final Builder latestSampleTime(Instant latestSampleTime) {
            this.latestSampleTime = latestSampleTime;
            return this;
        }

        public final Instant getLatestInference() {
            return this.latestInference;
        }

        public final void setLatestInference(Instant latestInference) {
            this.latestInference = latestInference;
        }

        @Override
        @Transient
        public final Builder latestInference(Instant latestInference) {
            this.latestInference = latestInference;
            return this;
        }

        public EdgeModel build() {
            return new EdgeModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeModel> {
        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder latestSampleTime(Instant var1);

        public Builder latestInference(Instant var1);
    }
}

