/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageVersionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateImageVersionRequest> {
    private static final SdkField<String> BASE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseImage").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::baseImage)).setter(CreateImageVersionRequest.setter(Builder::baseImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImage").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::clientToken)).setter(CreateImageVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::imageName)).setter(CreateImageVersionRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_IMAGE_FIELD, CLIENT_TOKEN_FIELD, IMAGE_NAME_FIELD));
    private final String baseImage;
    private final String clientToken;
    private final String imageName;

    private CreateImageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.baseImage = builder.baseImage;
        this.clientToken = builder.clientToken;
        this.imageName = builder.imageName;
    }

    public final String baseImage() {
        return this.baseImage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String imageName() {
        return this.imageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageVersionRequest)) {
            return false;
        }
        CreateImageVersionRequest other = (CreateImageVersionRequest)((Object)obj);
        return Objects.equals(this.baseImage(), other.baseImage()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.imageName(), other.imageName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageVersionRequest").add("BaseImage", (Object)this.baseImage()).add("ClientToken", (Object)this.clientToken()).add("ImageName", (Object)this.imageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseImage": {
                return Optional.ofNullable(clazz.cast(this.baseImage()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageVersionRequest, T> g) {
        return obj -> g.apply((CreateImageVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String baseImage;
        private String clientToken;
        private String imageName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageVersionRequest model) {
            super(model);
            this.baseImage(model.baseImage);
            this.clientToken(model.clientToken);
            this.imageName(model.imageName);
        }

        public final String getBaseImage() {
            return this.baseImage;
        }

        public final void setBaseImage(String baseImage) {
            this.baseImage = baseImage;
        }

        @Override
        public final Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageVersionRequest build() {
            return new CreateImageVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageVersionRequest> {
        public Builder baseImage(String var1);

        public Builder clientToken(String var1);

        public Builder imageName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

