/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse;
import software.amazon.awssdk.services.sagemaker.model.PipelineSummary;

public class ListPipelinesPublisher
implements SdkPublisher<ListPipelinesResponse> {
    private final SageMakerAsyncClient client;
    private final ListPipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelinesPublisher(SageMakerAsyncClient client, ListPipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelinesPublisher(SageMakerAsyncClient client, ListPipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineSummary> pipelineSummaries() {
        Function<ListPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineSummaries() != null) {
                return response.pipelineSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelinesResponseFetcher
    implements AsyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelinesResponse> nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesPublisher.this.client.listPipelines(ListPipelinesPublisher.this.firstRequest);
            }
            return ListPipelinesPublisher.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

