/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobDataAttributes;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobInputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobInputConfig> {
    private static final SdkField<LabelingJobDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(LabelingJobInputConfig.getter(LabelingJobInputConfig::dataSource)).setter(LabelingJobInputConfig.setter(Builder::dataSource)).constructor(LabelingJobDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<LabelingJobDataAttributes> DATA_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataAttributes").getter(LabelingJobInputConfig.getter(LabelingJobInputConfig::dataAttributes)).setter(LabelingJobInputConfig.setter(Builder::dataAttributes)).constructor(LabelingJobDataAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, DATA_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final LabelingJobDataSource dataSource;
    private final LabelingJobDataAttributes dataAttributes;

    private LabelingJobInputConfig(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.dataAttributes = builder.dataAttributes;
    }

    public final LabelingJobDataSource dataSource() {
        return this.dataSource;
    }

    public final LabelingJobDataAttributes dataAttributes() {
        return this.dataAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobInputConfig)) {
            return false;
        }
        LabelingJobInputConfig other = (LabelingJobInputConfig)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.dataAttributes(), other.dataAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"LabelingJobInputConfig").add("DataSource", (Object)this.dataSource()).add("DataAttributes", (Object)this.dataAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "DataAttributes": {
                return Optional.ofNullable(clazz.cast(this.dataAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobInputConfig, T> g) {
        return obj -> g.apply((LabelingJobInputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LabelingJobDataSource dataSource;
        private LabelingJobDataAttributes dataAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobInputConfig model) {
            this.dataSource(model.dataSource);
            this.dataAttributes(model.dataAttributes);
        }

        public final LabelingJobDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(LabelingJobDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(LabelingJobDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final LabelingJobDataAttributes.Builder getDataAttributes() {
            return this.dataAttributes != null ? this.dataAttributes.toBuilder() : null;
        }

        public final void setDataAttributes(LabelingJobDataAttributes.BuilderImpl dataAttributes) {
            this.dataAttributes = dataAttributes != null ? dataAttributes.build() : null;
        }

        @Override
        public final Builder dataAttributes(LabelingJobDataAttributes dataAttributes) {
            this.dataAttributes = dataAttributes;
            return this;
        }

        public LabelingJobInputConfig build() {
            return new LabelingJobInputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobInputConfig> {
        public Builder dataSource(LabelingJobDataSource var1);

        default public Builder dataSource(Consumer<LabelingJobDataSource.Builder> dataSource) {
            return this.dataSource((LabelingJobDataSource)((LabelingJobDataSource.Builder)LabelingJobDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder dataAttributes(LabelingJobDataAttributes var1);

        default public Builder dataAttributes(Consumer<LabelingJobDataAttributes.Builder> dataAttributes) {
            return this.dataAttributes((LabelingJobDataAttributes)((LabelingJobDataAttributes.Builder)LabelingJobDataAttributes.builder().applyMutation(dataAttributes)).build());
        }
    }
}

