/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.Endpoint;
import software.amazon.awssdk.services.sagemaker.model.Experiment;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroup;
import software.amazon.awssdk.services.sagemaker.model.FeatureMetadata;
import software.amazon.awssdk.services.sagemaker.model.ModelPackage;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroup;
import software.amazon.awssdk.services.sagemaker.model.Pipeline;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecution;
import software.amazon.awssdk.services.sagemaker.model.Project;
import software.amazon.awssdk.services.sagemaker.model.TrainingJob;
import software.amazon.awssdk.services.sagemaker.model.Trial;
import software.amazon.awssdk.services.sagemaker.model.TrialComponent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchRecord> {
    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingJob").getter(SearchRecord.getter(SearchRecord::trainingJob)).setter(SearchRecord.setter(Builder::trainingJob)).constructor(TrainingJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()}).build();
    private static final SdkField<Experiment> EXPERIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Experiment").getter(SearchRecord.getter(SearchRecord::experiment)).setter(SearchRecord.setter(Builder::experiment)).constructor(Experiment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Experiment").build()}).build();
    private static final SdkField<Trial> TRIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Trial").getter(SearchRecord.getter(SearchRecord::trial)).setter(SearchRecord.setter(Builder::trial)).constructor(Trial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trial").build()}).build();
    private static final SdkField<TrialComponent> TRIAL_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrialComponent").getter(SearchRecord.getter(SearchRecord::trialComponent)).setter(SearchRecord.setter(Builder::trialComponent)).constructor(TrialComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponent").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(SearchRecord.getter(SearchRecord::endpoint)).setter(SearchRecord.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<ModelPackage> MODEL_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelPackage").getter(SearchRecord.getter(SearchRecord::modelPackage)).setter(SearchRecord.setter(Builder::modelPackage)).constructor(ModelPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackage").build()}).build();
    private static final SdkField<ModelPackageGroup> MODEL_PACKAGE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelPackageGroup").getter(SearchRecord.getter(SearchRecord::modelPackageGroup)).setter(SearchRecord.setter(Builder::modelPackageGroup)).constructor(ModelPackageGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroup").build()}).build();
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pipeline").getter(SearchRecord.getter(SearchRecord::pipeline)).setter(SearchRecord.setter(Builder::pipeline)).constructor(Pipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()}).build();
    private static final SdkField<PipelineExecution> PIPELINE_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PipelineExecution").getter(SearchRecord.getter(SearchRecord::pipelineExecution)).setter(SearchRecord.setter(Builder::pipelineExecution)).constructor(PipelineExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecution").build()}).build();
    private static final SdkField<FeatureGroup> FEATURE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FeatureGroup").getter(SearchRecord.getter(SearchRecord::featureGroup)).setter(SearchRecord.setter(Builder::featureGroup)).constructor(FeatureGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroup").build()}).build();
    private static final SdkField<Project> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(SearchRecord.getter(SearchRecord::project)).setter(SearchRecord.setter(Builder::project)).constructor(Project::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final SdkField<FeatureMetadata> FEATURE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FeatureMetadata").getter(SearchRecord.getter(SearchRecord::featureMetadata)).setter(SearchRecord.setter(Builder::featureMetadata)).constructor(FeatureMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_FIELD, EXPERIMENT_FIELD, TRIAL_FIELD, TRIAL_COMPONENT_FIELD, ENDPOINT_FIELD, MODEL_PACKAGE_FIELD, MODEL_PACKAGE_GROUP_FIELD, PIPELINE_FIELD, PIPELINE_EXECUTION_FIELD, FEATURE_GROUP_FIELD, PROJECT_FIELD, FEATURE_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final TrainingJob trainingJob;
    private final Experiment experiment;
    private final Trial trial;
    private final TrialComponent trialComponent;
    private final Endpoint endpoint;
    private final ModelPackage modelPackage;
    private final ModelPackageGroup modelPackageGroup;
    private final Pipeline pipeline;
    private final PipelineExecution pipelineExecution;
    private final FeatureGroup featureGroup;
    private final Project project;
    private final FeatureMetadata featureMetadata;

    private SearchRecord(BuilderImpl builder) {
        this.trainingJob = builder.trainingJob;
        this.experiment = builder.experiment;
        this.trial = builder.trial;
        this.trialComponent = builder.trialComponent;
        this.endpoint = builder.endpoint;
        this.modelPackage = builder.modelPackage;
        this.modelPackageGroup = builder.modelPackageGroup;
        this.pipeline = builder.pipeline;
        this.pipelineExecution = builder.pipelineExecution;
        this.featureGroup = builder.featureGroup;
        this.project = builder.project;
        this.featureMetadata = builder.featureMetadata;
    }

    public final TrainingJob trainingJob() {
        return this.trainingJob;
    }

    public final Experiment experiment() {
        return this.experiment;
    }

    public final Trial trial() {
        return this.trial;
    }

    public final TrialComponent trialComponent() {
        return this.trialComponent;
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public final ModelPackage modelPackage() {
        return this.modelPackage;
    }

    public final ModelPackageGroup modelPackageGroup() {
        return this.modelPackageGroup;
    }

    public final Pipeline pipeline() {
        return this.pipeline;
    }

    public final PipelineExecution pipelineExecution() {
        return this.pipelineExecution;
    }

    public final FeatureGroup featureGroup() {
        return this.featureGroup;
    }

    public final Project project() {
        return this.project;
    }

    public final FeatureMetadata featureMetadata() {
        return this.featureMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.experiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.trial());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponent());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRecord)) {
            return false;
        }
        SearchRecord other = (SearchRecord)obj;
        return Objects.equals(this.trainingJob(), other.trainingJob()) && Objects.equals(this.experiment(), other.experiment()) && Objects.equals(this.trial(), other.trial()) && Objects.equals(this.trialComponent(), other.trialComponent()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.modelPackage(), other.modelPackage()) && Objects.equals(this.modelPackageGroup(), other.modelPackageGroup()) && Objects.equals(this.pipeline(), other.pipeline()) && Objects.equals(this.pipelineExecution(), other.pipelineExecution()) && Objects.equals(this.featureGroup(), other.featureGroup()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.featureMetadata(), other.featureMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRecord").add("TrainingJob", (Object)this.trainingJob()).add("Experiment", (Object)this.experiment()).add("Trial", (Object)this.trial()).add("TrialComponent", (Object)this.trialComponent()).add("Endpoint", (Object)this.endpoint()).add("ModelPackage", (Object)this.modelPackage()).add("ModelPackageGroup", (Object)this.modelPackageGroup()).add("Pipeline", (Object)this.pipeline()).add("PipelineExecution", (Object)this.pipelineExecution()).add("FeatureGroup", (Object)this.featureGroup()).add("Project", (Object)this.project()).add("FeatureMetadata", (Object)this.featureMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJob": {
                return Optional.ofNullable(clazz.cast(this.trainingJob()));
            }
            case "Experiment": {
                return Optional.ofNullable(clazz.cast(this.experiment()));
            }
            case "Trial": {
                return Optional.ofNullable(clazz.cast(this.trial()));
            }
            case "TrialComponent": {
                return Optional.ofNullable(clazz.cast(this.trialComponent()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ModelPackage": {
                return Optional.ofNullable(clazz.cast(this.modelPackage()));
            }
            case "ModelPackageGroup": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroup()));
            }
            case "Pipeline": {
                return Optional.ofNullable(clazz.cast(this.pipeline()));
            }
            case "PipelineExecution": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecution()));
            }
            case "FeatureGroup": {
                return Optional.ofNullable(clazz.cast(this.featureGroup()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "FeatureMetadata": {
                return Optional.ofNullable(clazz.cast(this.featureMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRecord, T> g) {
        return obj -> g.apply((SearchRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TrainingJob trainingJob;
        private Experiment experiment;
        private Trial trial;
        private TrialComponent trialComponent;
        private Endpoint endpoint;
        private ModelPackage modelPackage;
        private ModelPackageGroup modelPackageGroup;
        private Pipeline pipeline;
        private PipelineExecution pipelineExecution;
        private FeatureGroup featureGroup;
        private Project project;
        private FeatureMetadata featureMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRecord model) {
            this.trainingJob(model.trainingJob);
            this.experiment(model.experiment);
            this.trial(model.trial);
            this.trialComponent(model.trialComponent);
            this.endpoint(model.endpoint);
            this.modelPackage(model.modelPackage);
            this.modelPackageGroup(model.modelPackageGroup);
            this.pipeline(model.pipeline);
            this.pipelineExecution(model.pipelineExecution);
            this.featureGroup(model.featureGroup);
            this.project(model.project);
            this.featureMetadata(model.featureMetadata);
        }

        public final TrainingJob.Builder getTrainingJob() {
            return this.trainingJob != null ? this.trainingJob.toBuilder() : null;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final Experiment.Builder getExperiment() {
            return this.experiment != null ? this.experiment.toBuilder() : null;
        }

        public final void setExperiment(Experiment.BuilderImpl experiment) {
            this.experiment = experiment != null ? experiment.build() : null;
        }

        @Override
        public final Builder experiment(Experiment experiment) {
            this.experiment = experiment;
            return this;
        }

        public final Trial.Builder getTrial() {
            return this.trial != null ? this.trial.toBuilder() : null;
        }

        public final void setTrial(Trial.BuilderImpl trial) {
            this.trial = trial != null ? trial.build() : null;
        }

        @Override
        public final Builder trial(Trial trial) {
            this.trial = trial;
            return this;
        }

        public final TrialComponent.Builder getTrialComponent() {
            return this.trialComponent != null ? this.trialComponent.toBuilder() : null;
        }

        public final void setTrialComponent(TrialComponent.BuilderImpl trialComponent) {
            this.trialComponent = trialComponent != null ? trialComponent.build() : null;
        }

        @Override
        public final Builder trialComponent(TrialComponent trialComponent) {
            this.trialComponent = trialComponent;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final ModelPackage.Builder getModelPackage() {
            return this.modelPackage != null ? this.modelPackage.toBuilder() : null;
        }

        public final void setModelPackage(ModelPackage.BuilderImpl modelPackage) {
            this.modelPackage = modelPackage != null ? modelPackage.build() : null;
        }

        @Override
        public final Builder modelPackage(ModelPackage modelPackage) {
            this.modelPackage = modelPackage;
            return this;
        }

        public final ModelPackageGroup.Builder getModelPackageGroup() {
            return this.modelPackageGroup != null ? this.modelPackageGroup.toBuilder() : null;
        }

        public final void setModelPackageGroup(ModelPackageGroup.BuilderImpl modelPackageGroup) {
            this.modelPackageGroup = modelPackageGroup != null ? modelPackageGroup.build() : null;
        }

        @Override
        public final Builder modelPackageGroup(ModelPackageGroup modelPackageGroup) {
            this.modelPackageGroup = modelPackageGroup;
            return this;
        }

        public final Pipeline.Builder getPipeline() {
            return this.pipeline != null ? this.pipeline.toBuilder() : null;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final PipelineExecution.Builder getPipelineExecution() {
            return this.pipelineExecution != null ? this.pipelineExecution.toBuilder() : null;
        }

        public final void setPipelineExecution(PipelineExecution.BuilderImpl pipelineExecution) {
            this.pipelineExecution = pipelineExecution != null ? pipelineExecution.build() : null;
        }

        @Override
        public final Builder pipelineExecution(PipelineExecution pipelineExecution) {
            this.pipelineExecution = pipelineExecution;
            return this;
        }

        public final FeatureGroup.Builder getFeatureGroup() {
            return this.featureGroup != null ? this.featureGroup.toBuilder() : null;
        }

        public final void setFeatureGroup(FeatureGroup.BuilderImpl featureGroup) {
            this.featureGroup = featureGroup != null ? featureGroup.build() : null;
        }

        @Override
        public final Builder featureGroup(FeatureGroup featureGroup) {
            this.featureGroup = featureGroup;
            return this;
        }

        public final Project.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final FeatureMetadata.Builder getFeatureMetadata() {
            return this.featureMetadata != null ? this.featureMetadata.toBuilder() : null;
        }

        public final void setFeatureMetadata(FeatureMetadata.BuilderImpl featureMetadata) {
            this.featureMetadata = featureMetadata != null ? featureMetadata.build() : null;
        }

        @Override
        public final Builder featureMetadata(FeatureMetadata featureMetadata) {
            this.featureMetadata = featureMetadata;
            return this;
        }

        public SearchRecord build() {
            return new SearchRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchRecord> {
        public Builder trainingJob(TrainingJob var1);

        default public Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return this.trainingJob((TrainingJob)((TrainingJob.Builder)TrainingJob.builder().applyMutation(trainingJob)).build());
        }

        public Builder experiment(Experiment var1);

        default public Builder experiment(Consumer<Experiment.Builder> experiment) {
            return this.experiment((Experiment)((Experiment.Builder)Experiment.builder().applyMutation(experiment)).build());
        }

        public Builder trial(Trial var1);

        default public Builder trial(Consumer<Trial.Builder> trial) {
            return this.trial((Trial)((Trial.Builder)Trial.builder().applyMutation(trial)).build());
        }

        public Builder trialComponent(TrialComponent var1);

        default public Builder trialComponent(Consumer<TrialComponent.Builder> trialComponent) {
            return this.trialComponent((TrialComponent)((TrialComponent.Builder)TrialComponent.builder().applyMutation(trialComponent)).build());
        }

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder modelPackage(ModelPackage var1);

        default public Builder modelPackage(Consumer<ModelPackage.Builder> modelPackage) {
            return this.modelPackage((ModelPackage)((ModelPackage.Builder)ModelPackage.builder().applyMutation(modelPackage)).build());
        }

        public Builder modelPackageGroup(ModelPackageGroup var1);

        default public Builder modelPackageGroup(Consumer<ModelPackageGroup.Builder> modelPackageGroup) {
            return this.modelPackageGroup((ModelPackageGroup)((ModelPackageGroup.Builder)ModelPackageGroup.builder().applyMutation(modelPackageGroup)).build());
        }

        public Builder pipeline(Pipeline var1);

        default public Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return this.pipeline((Pipeline)((Pipeline.Builder)Pipeline.builder().applyMutation(pipeline)).build());
        }

        public Builder pipelineExecution(PipelineExecution var1);

        default public Builder pipelineExecution(Consumer<PipelineExecution.Builder> pipelineExecution) {
            return this.pipelineExecution((PipelineExecution)((PipelineExecution.Builder)PipelineExecution.builder().applyMutation(pipelineExecution)).build());
        }

        public Builder featureGroup(FeatureGroup var1);

        default public Builder featureGroup(Consumer<FeatureGroup.Builder> featureGroup) {
            return this.featureGroup((FeatureGroup)((FeatureGroup.Builder)FeatureGroup.builder().applyMutation(featureGroup)).build());
        }

        public Builder project(Project var1);

        default public Builder project(Consumer<Project.Builder> project) {
            return this.project((Project)((Project.Builder)Project.builder().applyMutation(project)).build());
        }

        public Builder featureMetadata(FeatureMetadata var1);

        default public Builder featureMetadata(Consumer<FeatureMetadata.Builder> featureMetadata) {
            return this.featureMetadata((FeatureMetadata)((FeatureMetadata.Builder)FeatureMetadata.builder().applyMutation(featureMetadata)).build());
        }
    }
}

