/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleEvaluationStatus {
    IN_PROGRESS("InProgress"),
    NO_ISSUES_FOUND("NoIssuesFound"),
    ISSUES_FOUND("IssuesFound"),
    ERROR("Error"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleEvaluationStatus> VALUE_MAP;
    private final String value;

    private RuleEvaluationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleEvaluationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleEvaluationStatus> knownValues() {
        EnumSet<RuleEvaluationStatus> knownValues = EnumSet.allOf(RuleEvaluationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleEvaluationStatus.class, RuleEvaluationStatus::toString);
    }
}

