/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary;

public class ListModelMetadataIterable
implements SdkIterable<ListModelMetadataResponse> {
    private final SageMakerClient client;
    private final ListModelMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelMetadataIterable(SageMakerClient client, ListModelMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelMetadataResponseFetcher();
    }

    public Iterator<ListModelMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelMetadataSummary> modelMetadataSummaries() {
        Function<ListModelMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelMetadataSummaries() != null) {
                return response.modelMetadataSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelMetadataResponseFetcher
    implements SyncPageFetcher<ListModelMetadataResponse> {
        private ListModelMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListModelMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelMetadataResponse nextPage(ListModelMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListModelMetadataIterable.this.client.listModelMetadata(ListModelMetadataIterable.this.firstRequest);
            }
            return ListModelMetadataIterable.this.client.listModelMetadata((ListModelMetadataRequest)((Object)ListModelMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

