/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointOutputConfiguration> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(EndpointOutputConfiguration.getter(EndpointOutputConfiguration::endpointName)).setter(EndpointOutputConfiguration.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(EndpointOutputConfiguration.getter(EndpointOutputConfiguration::variantName)).setter(EndpointOutputConfiguration.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(EndpointOutputConfiguration.getter(EndpointOutputConfiguration::instanceTypeAsString)).setter(EndpointOutputConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INITIAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InitialInstanceCount").getter(EndpointOutputConfiguration.getter(EndpointOutputConfiguration::initialInstanceCount)).setter(EndpointOutputConfiguration.setter(Builder::initialInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialInstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, VARIANT_NAME_FIELD, INSTANCE_TYPE_FIELD, INITIAL_INSTANCE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointName;
    private final String variantName;
    private final String instanceType;
    private final Integer initialInstanceCount;

    private EndpointOutputConfiguration(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.variantName = builder.variantName;
        this.instanceType = builder.instanceType;
        this.initialInstanceCount = builder.initialInstanceCount;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer initialInstanceCount() {
        return this.initialInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialInstanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointOutputConfiguration)) {
            return false;
        }
        EndpointOutputConfiguration other = (EndpointOutputConfiguration)obj;
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.initialInstanceCount(), other.initialInstanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointOutputConfiguration").add("EndpointName", (Object)this.endpointName()).add("VariantName", (Object)this.variantName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("InitialInstanceCount", (Object)this.initialInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InitialInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.initialInstanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointOutputConfiguration, T> g) {
        return obj -> g.apply((EndpointOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointName;
        private String variantName;
        private String instanceType;
        private Integer initialInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointOutputConfiguration model) {
            this.endpointName(model.endpointName);
            this.variantName(model.variantName);
            this.instanceType(model.instanceType);
            this.initialInstanceCount(model.initialInstanceCount);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        @Transient
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInitialInstanceCount() {
            return this.initialInstanceCount;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        @Override
        @Transient
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public EndpointOutputConfiguration build() {
            return new EndpointOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointOutputConfiguration> {
        public Builder endpointName(String var1);

        public Builder variantName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ProductionVariantInstanceType var1);

        public Builder initialInstanceCount(Integer var1);
    }
}

