/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;

public class ListEndpointsIterable
implements SdkIterable<ListEndpointsResponse> {
    private final SageMakerClient client;
    private final ListEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointsIterable(SageMakerClient client, ListEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointsResponseFetcher();
    }

    public Iterator<ListEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EndpointSummary> endpoints() {
        Function<ListEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEndpointsResponseFetcher
    implements SyncPageFetcher<ListEndpointsResponse> {
        private ListEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEndpointsResponse nextPage(ListEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsIterable.this.client.listEndpoints(ListEndpointsIterable.this.firstRequest);
            }
            return ListEndpointsIterable.this.client.listEndpoints((ListEndpointsRequest)((Object)ListEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

