/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary;
import software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitoringSchedulesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListMonitoringSchedulesResponse> {
    private static final SdkField<List<MonitoringScheduleSummary>> MONITORING_SCHEDULE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoringScheduleSummaries").getter(ListMonitoringSchedulesResponse.getter(ListMonitoringSchedulesResponse::monitoringScheduleSummaries)).setter(ListMonitoringSchedulesResponse.setter(Builder::monitoringScheduleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringScheduleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMonitoringSchedulesResponse.getter(ListMonitoringSchedulesResponse::nextToken)).setter(ListMonitoringSchedulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MonitoringScheduleSummary> monitoringScheduleSummaries;
    private final String nextToken;

    private ListMonitoringSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleSummaries = builder.monitoringScheduleSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMonitoringScheduleSummaries() {
        return this.monitoringScheduleSummaries != null && !(this.monitoringScheduleSummaries instanceof SdkAutoConstructList);
    }

    public final List<MonitoringScheduleSummary> monitoringScheduleSummaries() {
        return this.monitoringScheduleSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoringScheduleSummaries() ? this.monitoringScheduleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringSchedulesResponse)) {
            return false;
        }
        ListMonitoringSchedulesResponse other = (ListMonitoringSchedulesResponse)((Object)obj);
        return this.hasMonitoringScheduleSummaries() == other.hasMonitoringScheduleSummaries() && Objects.equals(this.monitoringScheduleSummaries(), other.monitoringScheduleSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitoringSchedulesResponse").add("MonitoringScheduleSummaries", this.hasMonitoringScheduleSummaries() ? this.monitoringScheduleSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleSummaries": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringSchedulesResponse, T> g) {
        return obj -> g.apply((ListMonitoringSchedulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<MonitoringScheduleSummary> monitoringScheduleSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringSchedulesResponse model) {
            super(model);
            this.monitoringScheduleSummaries(model.monitoringScheduleSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MonitoringScheduleSummary.Builder> getMonitoringScheduleSummaries() {
            List<MonitoringScheduleSummary.Builder> result = MonitoringScheduleSummaryListCopier.copyToBuilder(this.monitoringScheduleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringScheduleSummaries(Collection<MonitoringScheduleSummary.BuilderImpl> monitoringScheduleSummaries) {
            this.monitoringScheduleSummaries = MonitoringScheduleSummaryListCopier.copyFromBuilder(monitoringScheduleSummaries);
        }

        @Override
        @Transient
        public final Builder monitoringScheduleSummaries(Collection<MonitoringScheduleSummary> monitoringScheduleSummaries) {
            this.monitoringScheduleSummaries = MonitoringScheduleSummaryListCopier.copy(monitoringScheduleSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringScheduleSummaries(MonitoringScheduleSummary ... monitoringScheduleSummaries) {
            this.monitoringScheduleSummaries(Arrays.asList(monitoringScheduleSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringScheduleSummaries(Consumer<MonitoringScheduleSummary.Builder> ... monitoringScheduleSummaries) {
            this.monitoringScheduleSummaries(Stream.of(monitoringScheduleSummaries).map(c -> (MonitoringScheduleSummary)((MonitoringScheduleSummary.Builder)MonitoringScheduleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitoringSchedulesResponse build() {
            return new ListMonitoringSchedulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitoringSchedulesResponse> {
        public Builder monitoringScheduleSummaries(Collection<MonitoringScheduleSummary> var1);

        public Builder monitoringScheduleSummaries(MonitoringScheduleSummary ... var1);

        public Builder monitoringScheduleSummaries(Consumer<MonitoringScheduleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

