/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SplitType {
    NONE("None"),
    LINE("Line"),
    RECORD_IO("RecordIO"),
    TF_RECORD("TFRecord"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SplitType> VALUE_MAP;
    private final String value;

    private SplitType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SplitType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SplitType> knownValues() {
        EnumSet<SplitType> knownValues = EnumSet.allOf(SplitType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SplitType.class, SplitType::toString);
    }
}

