/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePipelineExecutionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribePipelineExecutionResponse> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::pipelineArn)).setter(DescribePipelineExecutionResponse.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionArn").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::pipelineExecutionArn)).setter(DescribePipelineExecutionResponse.setter(Builder::pipelineExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionDisplayName").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::pipelineExecutionDisplayName)).setter(DescribePipelineExecutionResponse.setter(Builder::pipelineExecutionDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionStatus").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::pipelineExecutionStatusAsString)).setter(DescribePipelineExecutionResponse.setter(Builder::pipelineExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionStatus").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionDescription").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::pipelineExecutionDescription)).setter(DescribePipelineExecutionResponse.setter(Builder::pipelineExecutionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::creationTime)).setter(DescribePipelineExecutionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::lastModifiedTime)).setter(DescribePipelineExecutionResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::createdBy)).setter(DescribePipelineExecutionResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(DescribePipelineExecutionResponse.getter(DescribePipelineExecutionResponse::lastModifiedBy)).setter(DescribePipelineExecutionResponse.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, PIPELINE_EXECUTION_ARN_FIELD, PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PIPELINE_EXECUTION_STATUS_FIELD, PIPELINE_EXECUTION_DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD));
    private final String pipelineArn;
    private final String pipelineExecutionArn;
    private final String pipelineExecutionDisplayName;
    private final String pipelineExecutionStatus;
    private final String pipelineExecutionDescription;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final UserContext createdBy;
    private final UserContext lastModifiedBy;

    private DescribePipelineExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.pipelineExecutionStatus = builder.pipelineExecutionStatus;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final String pipelineExecutionArn() {
        return this.pipelineExecutionArn;
    }

    public final String pipelineExecutionDisplayName() {
        return this.pipelineExecutionDisplayName;
    }

    public final PipelineExecutionStatus pipelineExecutionStatus() {
        return PipelineExecutionStatus.fromValue(this.pipelineExecutionStatus);
    }

    public final String pipelineExecutionStatusAsString() {
        return this.pipelineExecutionStatus;
    }

    public final String pipelineExecutionDescription() {
        return this.pipelineExecutionDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelineExecutionResponse)) {
            return false;
        }
        DescribePipelineExecutionResponse other = (DescribePipelineExecutionResponse)((Object)obj);
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.pipelineExecutionArn(), other.pipelineExecutionArn()) && Objects.equals(this.pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName()) && Objects.equals(this.pipelineExecutionStatusAsString(), other.pipelineExecutionStatusAsString()) && Objects.equals(this.pipelineExecutionDescription(), other.pipelineExecutionDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePipelineExecutionResponse").add("PipelineArn", (Object)this.pipelineArn()).add("PipelineExecutionArn", (Object)this.pipelineExecutionArn()).add("PipelineExecutionDisplayName", (Object)this.pipelineExecutionDisplayName()).add("PipelineExecutionStatus", (Object)this.pipelineExecutionStatusAsString()).add("PipelineExecutionDescription", (Object)this.pipelineExecutionDescription()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedBy", (Object)this.lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "PipelineExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionArn()));
            }
            case "PipelineExecutionDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionDisplayName()));
            }
            case "PipelineExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionStatusAsString()));
            }
            case "PipelineExecutionDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelineExecutionResponse, T> g) {
        return obj -> g.apply((DescribePipelineExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String pipelineArn;
        private String pipelineExecutionArn;
        private String pipelineExecutionDisplayName;
        private String pipelineExecutionStatus;
        private String pipelineExecutionDescription;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private UserContext createdBy;
        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelineExecutionResponse model) {
            super(model);
            this.pipelineArn(model.pipelineArn);
            this.pipelineExecutionArn(model.pipelineExecutionArn);
            this.pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            this.pipelineExecutionStatus(model.pipelineExecutionStatus);
            this.pipelineExecutionDescription(model.pipelineExecutionDescription);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.createdBy(model.createdBy);
            this.lastModifiedBy(model.lastModifiedBy);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        public final String getPipelineExecutionArn() {
            return this.pipelineExecutionArn;
        }

        @Override
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        public final String getPipelineExecutionDisplayName() {
            return this.pipelineExecutionDisplayName;
        }

        @Override
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        public final String getPipelineExecutionStatus() {
            return this.pipelineExecutionStatus;
        }

        @Override
        public final Builder pipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus) {
            this.pipelineExecutionStatus(pipelineExecutionStatus == null ? null : pipelineExecutionStatus.toString());
            return this;
        }

        public final void setPipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
        }

        public final String getPipelineExecutionDescription() {
            return this.pipelineExecutionDescription;
        }

        @Override
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public DescribePipelineExecutionResponse build() {
            return new DescribePipelineExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePipelineExecutionResponse> {
        public Builder pipelineArn(String var1);

        public Builder pipelineExecutionArn(String var1);

        public Builder pipelineExecutionDisplayName(String var1);

        public Builder pipelineExecutionStatus(String var1);

        public Builder pipelineExecutionStatus(PipelineExecutionStatus var1);

        public Builder pipelineExecutionDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }
    }
}

