/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.CollectionConfiguration;
import software.amazon.awssdk.services.sagemaker.model.CollectionConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.HookParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DebugHookConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DebugHookConfig> {
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPath").getter(DebugHookConfig.getter(DebugHookConfig::localPath)).setter(DebugHookConfig.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(DebugHookConfig.getter(DebugHookConfig::s3OutputPath)).setter(DebugHookConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<Map<String, String>> HOOK_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("HookParameters").getter(DebugHookConfig.getter(DebugHookConfig::hookParameters)).setter(DebugHookConfig.setter(Builder::hookParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<CollectionConfiguration>> COLLECTION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CollectionConfigurations").getter(DebugHookConfig.getter(DebugHookConfig::collectionConfigurations)).setter(DebugHookConfig.setter(Builder::collectionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PATH_FIELD, S3_OUTPUT_PATH_FIELD, HOOK_PARAMETERS_FIELD, COLLECTION_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String localPath;
    private final String s3OutputPath;
    private final Map<String, String> hookParameters;
    private final List<CollectionConfiguration> collectionConfigurations;

    private DebugHookConfig(BuilderImpl builder) {
        this.localPath = builder.localPath;
        this.s3OutputPath = builder.s3OutputPath;
        this.hookParameters = builder.hookParameters;
        this.collectionConfigurations = builder.collectionConfigurations;
    }

    public final String localPath() {
        return this.localPath;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final boolean hasHookParameters() {
        return this.hookParameters != null && !(this.hookParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hookParameters() {
        return this.hookParameters;
    }

    public final boolean hasCollectionConfigurations() {
        return this.collectionConfigurations != null && !(this.collectionConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CollectionConfiguration> collectionConfigurations() {
        return this.collectionConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHookParameters() ? this.hookParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionConfigurations() ? this.collectionConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugHookConfig)) {
            return false;
        }
        DebugHookConfig other = (DebugHookConfig)obj;
        return Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && this.hasHookParameters() == other.hasHookParameters() && Objects.equals(this.hookParameters(), other.hookParameters()) && this.hasCollectionConfigurations() == other.hasCollectionConfigurations() && Objects.equals(this.collectionConfigurations(), other.collectionConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"DebugHookConfig").add("LocalPath", (Object)this.localPath()).add("S3OutputPath", (Object)this.s3OutputPath()).add("HookParameters", this.hasHookParameters() ? this.hookParameters() : null).add("CollectionConfigurations", this.hasCollectionConfigurations() ? this.collectionConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "HookParameters": {
                return Optional.ofNullable(clazz.cast(this.hookParameters()));
            }
            case "CollectionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.collectionConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DebugHookConfig, T> g) {
        return obj -> g.apply((DebugHookConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localPath;
        private String s3OutputPath;
        private Map<String, String> hookParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<CollectionConfiguration> collectionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DebugHookConfig model) {
            this.localPath(model.localPath);
            this.s3OutputPath(model.s3OutputPath);
            this.hookParameters(model.hookParameters);
            this.collectionConfigurations(model.collectionConfigurations);
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public final Map<String, String> getHookParameters() {
            if (this.hookParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hookParameters;
        }

        @Override
        public final Builder hookParameters(Map<String, String> hookParameters) {
            this.hookParameters = HookParametersCopier.copy(hookParameters);
            return this;
        }

        public final void setHookParameters(Map<String, String> hookParameters) {
            this.hookParameters = HookParametersCopier.copy(hookParameters);
        }

        public final Collection<CollectionConfiguration.Builder> getCollectionConfigurations() {
            if (this.collectionConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.collectionConfigurations != null ? (Collection)this.collectionConfigurations.stream().map(CollectionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder collectionConfigurations(Collection<CollectionConfiguration> collectionConfigurations) {
            this.collectionConfigurations = CollectionConfigurationsCopier.copy(collectionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionConfigurations(CollectionConfiguration ... collectionConfigurations) {
            this.collectionConfigurations(Arrays.asList(collectionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionConfigurations(Consumer<CollectionConfiguration.Builder> ... collectionConfigurations) {
            this.collectionConfigurations(Stream.of(collectionConfigurations).map(c -> (CollectionConfiguration)((CollectionConfiguration.Builder)CollectionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCollectionConfigurations(Collection<CollectionConfiguration.BuilderImpl> collectionConfigurations) {
            this.collectionConfigurations = CollectionConfigurationsCopier.copyFromBuilder(collectionConfigurations);
        }

        public DebugHookConfig build() {
            return new DebugHookConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DebugHookConfig> {
        public Builder localPath(String var1);

        public Builder s3OutputPath(String var1);

        public Builder hookParameters(Map<String, String> var1);

        public Builder collectionConfigurations(Collection<CollectionConfiguration> var1);

        public Builder collectionConfigurations(CollectionConfiguration ... var1);

        public Builder collectionConfigurations(Consumer<CollectionConfiguration.Builder> ... var1);
    }
}

