/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AssociationSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.AssociationSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociationsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListAssociationsResponse> {
    private static final SdkField<List<AssociationSummary>> ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationSummaries").getter(ListAssociationsResponse.getter(ListAssociationsResponse::associationSummaries)).setter(ListAssociationsResponse.setter(Builder::associationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssociationsResponse.getter(ListAssociationsResponse::nextToken)).setter(ListAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssociationSummary> associationSummaries;
    private final String nextToken;

    private ListAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associationSummaries = builder.associationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociationSummaries() {
        return this.associationSummaries != null && !(this.associationSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssociationSummary> associationSummaries() {
        return this.associationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationSummaries() ? this.associationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsResponse)) {
            return false;
        }
        ListAssociationsResponse other = (ListAssociationsResponse)((Object)obj);
        return this.hasAssociationSummaries() == other.hasAssociationSummaries() && Objects.equals(this.associationSummaries(), other.associationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociationsResponse").add("AssociationSummaries", this.hasAssociationSummaries() ? this.associationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.associationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationsResponse, T> g) {
        return obj -> g.apply((ListAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<AssociationSummary> associationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsResponse model) {
            super(model);
            this.associationSummaries(model.associationSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssociationSummary.Builder> getAssociationSummaries() {
            if (this.associationSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associationSummaries != null ? (Collection)this.associationSummaries.stream().map(AssociationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationSummaries(Collection<AssociationSummary> associationSummaries) {
            this.associationSummaries = AssociationSummariesCopier.copy(associationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationSummaries(AssociationSummary ... associationSummaries) {
            this.associationSummaries(Arrays.asList(associationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationSummaries(Consumer<AssociationSummary.Builder> ... associationSummaries) {
            this.associationSummaries(Stream.of(associationSummaries).map(c -> (AssociationSummary)((AssociationSummary.Builder)AssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociationSummaries(Collection<AssociationSummary.BuilderImpl> associationSummaries) {
            this.associationSummaries = AssociationSummariesCopier.copyFromBuilder(associationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociationsResponse build() {
            return new ListAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociationsResponse> {
        public Builder associationSummaries(Collection<AssociationSummary> var1);

        public Builder associationSummaries(AssociationSummary ... var1);

        public Builder associationSummaries(Consumer<AssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

