/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageContainerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageContainerDefinition> {
    private static final SdkField<String> CONTAINER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerHostname").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::containerHostname)).setter(ModelPackageContainerDefinition.setter(Builder::containerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerHostname").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::image)).setter(ModelPackageContainerDefinition.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageDigest").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::imageDigest)).setter(ModelPackageContainerDefinition.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDigest").build()}).build();
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelDataUrl").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::modelDataUrl)).setter(ModelPackageContainerDefinition.setter(Builder::modelDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::productId)).setter(ModelPackageContainerDefinition.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_HOSTNAME_FIELD, IMAGE_FIELD, IMAGE_DIGEST_FIELD, MODEL_DATA_URL_FIELD, PRODUCT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerHostname;
    private final String image;
    private final String imageDigest;
    private final String modelDataUrl;
    private final String productId;

    private ModelPackageContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.imageDigest = builder.imageDigest;
        this.modelDataUrl = builder.modelDataUrl;
        this.productId = builder.productId;
    }

    public final String containerHostname() {
        return this.containerHostname;
    }

    public final String image() {
        return this.image;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final String modelDataUrl() {
        return this.modelDataUrl;
    }

    public final String productId() {
        return this.productId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageContainerDefinition)) {
            return false;
        }
        ModelPackageContainerDefinition other = (ModelPackageContainerDefinition)obj;
        return Objects.equals(this.containerHostname(), other.containerHostname()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.productId(), other.productId());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackageContainerDefinition").add("ContainerHostname", (Object)this.containerHostname()).add("Image", (Object)this.image()).add("ImageDigest", (Object)this.imageDigest()).add("ModelDataUrl", (Object)this.modelDataUrl()).add("ProductId", (Object)this.productId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerHostname": {
                return Optional.ofNullable(clazz.cast(this.containerHostname()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ImageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "ModelDataUrl": {
                return Optional.ofNullable(clazz.cast(this.modelDataUrl()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageContainerDefinition, T> g) {
        return obj -> g.apply((ModelPackageContainerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerHostname;
        private String image;
        private String imageDigest;
        private String modelDataUrl;
        private String productId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageContainerDefinition model) {
            this.containerHostname(model.containerHostname);
            this.image(model.image);
            this.imageDigest(model.imageDigest);
            this.modelDataUrl(model.modelDataUrl);
            this.productId(model.productId);
        }

        public final String getContainerHostname() {
            return this.containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public ModelPackageContainerDefinition build() {
            return new ModelPackageContainerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageContainerDefinition> {
        public Builder containerHostname(String var1);

        public Builder image(String var1);

        public Builder imageDigest(String var1);

        public Builder modelDataUrl(String var1);

        public Builder productId(String var1);
    }
}

