/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLabelingJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateLabelingJobRequest> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobName").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::labelingJobName)).setter(CreateLabelingJobRequest.setter(Builder::labelingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()}).build();
    private static final SdkField<String> LABEL_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelAttributeName").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::labelAttributeName)).setter(CreateLabelingJobRequest.setter(Builder::labelAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelAttributeName").build()}).build();
    private static final SdkField<LabelingJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::inputConfig)).setter(CreateLabelingJobRequest.setter(Builder::inputConfig)).constructor(LabelingJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<LabelingJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::outputConfig)).setter(CreateLabelingJobRequest.setter(Builder::outputConfig)).constructor(LabelingJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::roleArn)).setter(CreateLabelingJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> LABEL_CATEGORY_CONFIG_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelCategoryConfigS3Uri").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::labelCategoryConfigS3Uri)).setter(CreateLabelingJobRequest.setter(Builder::labelCategoryConfigS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryConfigS3Uri").build()}).build();
    private static final SdkField<LabelingJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingConditions").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::stoppingConditions)).setter(CreateLabelingJobRequest.setter(Builder::stoppingConditions)).constructor(LabelingJobStoppingConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build()}).build();
    private static final SdkField<LabelingJobAlgorithmsConfig> LABELING_JOB_ALGORITHMS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelingJobAlgorithmsConfig").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::labelingJobAlgorithmsConfig)).setter(CreateLabelingJobRequest.setter(Builder::labelingJobAlgorithmsConfig)).constructor(LabelingJobAlgorithmsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobAlgorithmsConfig").build()}).build();
    private static final SdkField<HumanTaskConfig> HUMAN_TASK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanTaskConfig").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::humanTaskConfig)).setter(CreateLabelingJobRequest.setter(Builder::humanTaskConfig)).constructor(HumanTaskConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLabelingJobRequest.getter(CreateLabelingJobRequest::tags)).setter(CreateLabelingJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD, LABEL_ATTRIBUTE_NAME_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, ROLE_ARN_FIELD, LABEL_CATEGORY_CONFIG_S3_URI_FIELD, STOPPING_CONDITIONS_FIELD, LABELING_JOB_ALGORITHMS_CONFIG_FIELD, HUMAN_TASK_CONFIG_FIELD, TAGS_FIELD));
    private final String labelingJobName;
    private final String labelAttributeName;
    private final LabelingJobInputConfig inputConfig;
    private final LabelingJobOutputConfig outputConfig;
    private final String roleArn;
    private final String labelCategoryConfigS3Uri;
    private final LabelingJobStoppingConditions stoppingConditions;
    private final LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;
    private final HumanTaskConfig humanTaskConfig;
    private final List<Tag> tags;

    private CreateLabelingJobRequest(BuilderImpl builder) {
        super(builder);
        this.labelingJobName = builder.labelingJobName;
        this.labelAttributeName = builder.labelAttributeName;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.labelCategoryConfigS3Uri = builder.labelCategoryConfigS3Uri;
        this.stoppingConditions = builder.stoppingConditions;
        this.labelingJobAlgorithmsConfig = builder.labelingJobAlgorithmsConfig;
        this.humanTaskConfig = builder.humanTaskConfig;
        this.tags = builder.tags;
    }

    public final String labelingJobName() {
        return this.labelingJobName;
    }

    public final String labelAttributeName() {
        return this.labelAttributeName;
    }

    public final LabelingJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final LabelingJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String labelCategoryConfigS3Uri() {
        return this.labelCategoryConfigS3Uri;
    }

    public final LabelingJobStoppingConditions stoppingConditions() {
        return this.stoppingConditions;
    }

    public final LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig() {
        return this.labelingJobAlgorithmsConfig;
    }

    public final HumanTaskConfig humanTaskConfig() {
        return this.humanTaskConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCategoryConfigS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobAlgorithmsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelingJobRequest)) {
            return false;
        }
        CreateLabelingJobRequest other = (CreateLabelingJobRequest)((Object)obj);
        return Objects.equals(this.labelingJobName(), other.labelingJobName()) && Objects.equals(this.labelAttributeName(), other.labelAttributeName()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.labelCategoryConfigS3Uri(), other.labelCategoryConfigS3Uri()) && Objects.equals(this.stoppingConditions(), other.stoppingConditions()) && Objects.equals(this.labelingJobAlgorithmsConfig(), other.labelingJobAlgorithmsConfig()) && Objects.equals(this.humanTaskConfig(), other.humanTaskConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLabelingJobRequest").add("LabelingJobName", (Object)this.labelingJobName()).add("LabelAttributeName", (Object)this.labelAttributeName()).add("InputConfig", (Object)this.inputConfig()).add("OutputConfig", (Object)this.outputConfig()).add("RoleArn", (Object)this.roleArn()).add("LabelCategoryConfigS3Uri", (Object)this.labelCategoryConfigS3Uri()).add("StoppingConditions", (Object)this.stoppingConditions()).add("LabelingJobAlgorithmsConfig", (Object)this.labelingJobAlgorithmsConfig()).add("HumanTaskConfig", (Object)this.humanTaskConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobName": {
                return Optional.ofNullable(clazz.cast(this.labelingJobName()));
            }
            case "LabelAttributeName": {
                return Optional.ofNullable(clazz.cast(this.labelAttributeName()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LabelCategoryConfigS3Uri": {
                return Optional.ofNullable(clazz.cast(this.labelCategoryConfigS3Uri()));
            }
            case "StoppingConditions": {
                return Optional.ofNullable(clazz.cast(this.stoppingConditions()));
            }
            case "LabelingJobAlgorithmsConfig": {
                return Optional.ofNullable(clazz.cast(this.labelingJobAlgorithmsConfig()));
            }
            case "HumanTaskConfig": {
                return Optional.ofNullable(clazz.cast(this.humanTaskConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLabelingJobRequest, T> g) {
        return obj -> g.apply((CreateLabelingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String labelingJobName;
        private String labelAttributeName;
        private LabelingJobInputConfig inputConfig;
        private LabelingJobOutputConfig outputConfig;
        private String roleArn;
        private String labelCategoryConfigS3Uri;
        private LabelingJobStoppingConditions stoppingConditions;
        private LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;
        private HumanTaskConfig humanTaskConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelingJobRequest model) {
            super(model);
            this.labelingJobName(model.labelingJobName);
            this.labelAttributeName(model.labelAttributeName);
            this.inputConfig(model.inputConfig);
            this.outputConfig(model.outputConfig);
            this.roleArn(model.roleArn);
            this.labelCategoryConfigS3Uri(model.labelCategoryConfigS3Uri);
            this.stoppingConditions(model.stoppingConditions);
            this.labelingJobAlgorithmsConfig(model.labelingJobAlgorithmsConfig);
            this.humanTaskConfig(model.humanTaskConfig);
            this.tags(model.tags);
        }

        public final String getLabelingJobName() {
            return this.labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        public final String getLabelAttributeName() {
            return this.labelAttributeName;
        }

        @Override
        public final Builder labelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
            return this;
        }

        public final void setLabelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
        }

        public final LabelingJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputConfig(LabelingJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final void setInputConfig(LabelingJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        public final LabelingJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(LabelingJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(LabelingJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLabelCategoryConfigS3Uri() {
            return this.labelCategoryConfigS3Uri;
        }

        @Override
        public final Builder labelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
            return this;
        }

        public final void setLabelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
        }

        public final LabelingJobStoppingConditions.Builder getStoppingConditions() {
            return this.stoppingConditions != null ? this.stoppingConditions.toBuilder() : null;
        }

        @Override
        public final Builder stoppingConditions(LabelingJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final void setStoppingConditions(LabelingJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        public final LabelingJobAlgorithmsConfig.Builder getLabelingJobAlgorithmsConfig() {
            return this.labelingJobAlgorithmsConfig != null ? this.labelingJobAlgorithmsConfig.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig;
            return this;
        }

        public final void setLabelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig.BuilderImpl labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig != null ? labelingJobAlgorithmsConfig.build() : null;
        }

        public final HumanTaskConfig.Builder getHumanTaskConfig() {
            return this.humanTaskConfig != null ? this.humanTaskConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanTaskConfig(HumanTaskConfig humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig;
            return this;
        }

        public final void setHumanTaskConfig(HumanTaskConfig.BuilderImpl humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig != null ? humanTaskConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLabelingJobRequest build() {
            return new CreateLabelingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLabelingJobRequest> {
        public Builder labelingJobName(String var1);

        public Builder labelAttributeName(String var1);

        public Builder inputConfig(LabelingJobInputConfig var1);

        default public Builder inputConfig(Consumer<LabelingJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((LabelingJobInputConfig)((LabelingJobInputConfig.Builder)LabelingJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder outputConfig(LabelingJobOutputConfig var1);

        default public Builder outputConfig(Consumer<LabelingJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((LabelingJobOutputConfig)((LabelingJobOutputConfig.Builder)LabelingJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder labelCategoryConfigS3Uri(String var1);

        public Builder stoppingConditions(LabelingJobStoppingConditions var1);

        default public Builder stoppingConditions(Consumer<LabelingJobStoppingConditions.Builder> stoppingConditions) {
            return this.stoppingConditions((LabelingJobStoppingConditions)((LabelingJobStoppingConditions.Builder)LabelingJobStoppingConditions.builder().applyMutation(stoppingConditions)).build());
        }

        public Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig var1);

        default public Builder labelingJobAlgorithmsConfig(Consumer<LabelingJobAlgorithmsConfig.Builder> labelingJobAlgorithmsConfig) {
            return this.labelingJobAlgorithmsConfig((LabelingJobAlgorithmsConfig)((LabelingJobAlgorithmsConfig.Builder)LabelingJobAlgorithmsConfig.builder().applyMutation(labelingJobAlgorithmsConfig)).build());
        }

        public Builder humanTaskConfig(HumanTaskConfig var1);

        default public Builder humanTaskConfig(Consumer<HumanTaskConfig.Builder> humanTaskConfig) {
            return this.humanTaskConfig((HumanTaskConfig)((HumanTaskConfig.Builder)HumanTaskConfig.builder().applyMutation(humanTaskConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

