/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.UserProfileDetails;

public class ListUserProfilesIterable
implements SdkIterable<ListUserProfilesResponse> {
    private final SageMakerClient client;
    private final ListUserProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserProfilesIterable(SageMakerClient client, ListUserProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUserProfilesResponseFetcher();
    }

    public Iterator<ListUserProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserProfileDetails> userProfiles() {
        Function<ListUserProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.userProfiles() != null) {
                return response.userProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserProfilesResponseFetcher
    implements SyncPageFetcher<ListUserProfilesResponse> {
        private ListUserProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserProfilesResponse nextPage(ListUserProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListUserProfilesIterable.this.client.listUserProfiles(ListUserProfilesIterable.this.firstRequest);
            }
            return ListUserProfilesIterable.this.client.listUserProfiles((ListUserProfilesRequest)((Object)ListUserProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

