/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary;

public class ListModelPackageGroupsIterable
implements SdkIterable<ListModelPackageGroupsResponse> {
    private final SageMakerClient client;
    private final ListModelPackageGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelPackageGroupsIterable(SageMakerClient client, ListModelPackageGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelPackageGroupsResponseFetcher();
    }

    public Iterator<ListModelPackageGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelPackageGroupSummary> modelPackageGroupSummaryList() {
        Function<ListModelPackageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelPackageGroupSummaryList() != null) {
                return response.modelPackageGroupSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelPackageGroupsResponseFetcher
    implements SyncPageFetcher<ListModelPackageGroupsResponse> {
        private ListModelPackageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelPackageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelPackageGroupsResponse nextPage(ListModelPackageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListModelPackageGroupsIterable.this.client.listModelPackageGroups(ListModelPackageGroupsIterable.this.firstRequest);
            }
            return ListModelPackageGroupsIterable.this.client.listModelPackageGroups((ListModelPackageGroupsRequest)((Object)ListModelPackageGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

