/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OidcConfigForResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OidcConfigForResponse> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(OidcConfigForResponse.getter(OidcConfigForResponse::clientId)).setter(OidcConfigForResponse.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(OidcConfigForResponse.getter(OidcConfigForResponse::issuer)).setter(OidcConfigForResponse.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationEndpoint").getter(OidcConfigForResponse.getter(OidcConfigForResponse::authorizationEndpoint)).setter(OidcConfigForResponse.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenEndpoint").getter(OidcConfigForResponse.getter(OidcConfigForResponse::tokenEndpoint)).setter(OidcConfigForResponse.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()}).build();
    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserInfoEndpoint").getter(OidcConfigForResponse.getter(OidcConfigForResponse::userInfoEndpoint)).setter(OidcConfigForResponse.setter(Builder::userInfoEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").build()}).build();
    private static final SdkField<String> LOGOUT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogoutEndpoint").getter(OidcConfigForResponse.getter(OidcConfigForResponse::logoutEndpoint)).setter(OidcConfigForResponse.setter(Builder::logoutEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutEndpoint").build()}).build();
    private static final SdkField<String> JWKS_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JwksUri").getter(OidcConfigForResponse.getter(OidcConfigForResponse::jwksUri)).setter(OidcConfigForResponse.setter(Builder::jwksUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, LOGOUT_ENDPOINT_FIELD, JWKS_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;
    private final String logoutEndpoint;
    private final String jwksUri;

    private OidcConfigForResponse(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.logoutEndpoint = builder.logoutEndpoint;
        this.jwksUri = builder.jwksUri;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final String userInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public final String logoutEndpoint() {
        return this.logoutEndpoint;
    }

    public final String jwksUri() {
        return this.jwksUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoutEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwksUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcConfigForResponse)) {
            return false;
        }
        OidcConfigForResponse other = (OidcConfigForResponse)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(this.logoutEndpoint(), other.logoutEndpoint()) && Objects.equals(this.jwksUri(), other.jwksUri());
    }

    public final String toString() {
        return ToString.builder((String)"OidcConfigForResponse").add("ClientId", (Object)this.clientId()).add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("UserInfoEndpoint", (Object)this.userInfoEndpoint()).add("LogoutEndpoint", (Object)this.logoutEndpoint()).add("JwksUri", (Object)this.jwksUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "TokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "UserInfoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.userInfoEndpoint()));
            }
            case "LogoutEndpoint": {
                return Optional.ofNullable(clazz.cast(this.logoutEndpoint()));
            }
            case "JwksUri": {
                return Optional.ofNullable(clazz.cast(this.jwksUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OidcConfigForResponse, T> g) {
        return obj -> g.apply((OidcConfigForResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String issuer;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String userInfoEndpoint;
        private String logoutEndpoint;
        private String jwksUri;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcConfigForResponse model) {
            this.clientId(model.clientId);
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
            this.userInfoEndpoint(model.userInfoEndpoint);
            this.logoutEndpoint(model.logoutEndpoint);
            this.jwksUri(model.jwksUri);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public final String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        public final String getLogoutEndpoint() {
            return this.logoutEndpoint;
        }

        @Override
        public final Builder logoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
            return this;
        }

        public final void setLogoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
        }

        public final String getJwksUri() {
            return this.jwksUri;
        }

        @Override
        public final Builder jwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        public final void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }

        public OidcConfigForResponse build() {
            return new OidcConfigForResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OidcConfigForResponse> {
        public Builder clientId(String var1);

        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder userInfoEndpoint(String var1);

        public Builder logoutEndpoint(String var1);

        public Builder jwksUri(String var1);
    }
}

