/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineExecutionStepsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListPipelineExecutionStepsResponse> {
    private static final SdkField<List<PipelineExecutionStep>> PIPELINE_EXECUTION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineExecutionSteps").getter(ListPipelineExecutionStepsResponse.getter(ListPipelineExecutionStepsResponse::pipelineExecutionSteps)).setter(ListPipelineExecutionStepsResponse.setter(Builder::pipelineExecutionSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineExecutionStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipelineExecutionStepsResponse.getter(ListPipelineExecutionStepsResponse::nextToken)).setter(ListPipelineExecutionStepsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_STEPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PipelineExecutionStep> pipelineExecutionSteps;
    private final String nextToken;

    private ListPipelineExecutionStepsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionSteps = builder.pipelineExecutionSteps;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPipelineExecutionSteps() {
        return this.pipelineExecutionSteps != null && !(this.pipelineExecutionSteps instanceof SdkAutoConstructList);
    }

    public final List<PipelineExecutionStep> pipelineExecutionSteps() {
        return this.pipelineExecutionSteps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineExecutionSteps() ? this.pipelineExecutionSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineExecutionStepsResponse)) {
            return false;
        }
        ListPipelineExecutionStepsResponse other = (ListPipelineExecutionStepsResponse)((Object)obj);
        return this.hasPipelineExecutionSteps() == other.hasPipelineExecutionSteps() && Objects.equals(this.pipelineExecutionSteps(), other.pipelineExecutionSteps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineExecutionStepsResponse").add("PipelineExecutionSteps", this.hasPipelineExecutionSteps() ? this.pipelineExecutionSteps() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineExecutionSteps": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionSteps()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineExecutionStepsResponse, T> g) {
        return obj -> g.apply((ListPipelineExecutionStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<PipelineExecutionStep> pipelineExecutionSteps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineExecutionStepsResponse model) {
            super(model);
            this.pipelineExecutionSteps(model.pipelineExecutionSteps);
            this.nextToken(model.nextToken);
        }

        public final Collection<PipelineExecutionStep.Builder> getPipelineExecutionSteps() {
            if (this.pipelineExecutionSteps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pipelineExecutionSteps != null ? (Collection)this.pipelineExecutionSteps.stream().map(PipelineExecutionStep::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineExecutionSteps(Collection<PipelineExecutionStep> pipelineExecutionSteps) {
            this.pipelineExecutionSteps = PipelineExecutionStepListCopier.copy(pipelineExecutionSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSteps(PipelineExecutionStep ... pipelineExecutionSteps) {
            this.pipelineExecutionSteps(Arrays.asList(pipelineExecutionSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSteps(Consumer<PipelineExecutionStep.Builder> ... pipelineExecutionSteps) {
            this.pipelineExecutionSteps(Stream.of(pipelineExecutionSteps).map(c -> (PipelineExecutionStep)((PipelineExecutionStep.Builder)PipelineExecutionStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineExecutionSteps(Collection<PipelineExecutionStep.BuilderImpl> pipelineExecutionSteps) {
            this.pipelineExecutionSteps = PipelineExecutionStepListCopier.copyFromBuilder(pipelineExecutionSteps);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPipelineExecutionStepsResponse build() {
            return new ListPipelineExecutionStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineExecutionStepsResponse> {
        public Builder pipelineExecutionSteps(Collection<PipelineExecutionStep> var1);

        public Builder pipelineExecutionSteps(PipelineExecutionStep ... var1);

        public Builder pipelineExecutionSteps(Consumer<PipelineExecutionStep.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

