/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobOutputConfig> {
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(LabelingJobOutputConfig.getter(LabelingJobOutputConfig::s3OutputPath)).setter(LabelingJobOutputConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(LabelingJobOutputConfig.getter(LabelingJobOutputConfig::kmsKeyId)).setter(LabelingJobOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(LabelingJobOutputConfig.getter(LabelingJobOutputConfig::snsTopicArn)).setter(LabelingJobOutputConfig.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_PATH_FIELD, KMS_KEY_ID_FIELD, SNS_TOPIC_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3OutputPath;
    private final String kmsKeyId;
    private final String snsTopicArn;

    private LabelingJobOutputConfig(BuilderImpl builder) {
        this.s3OutputPath = builder.s3OutputPath;
        this.kmsKeyId = builder.kmsKeyId;
        this.snsTopicArn = builder.snsTopicArn;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobOutputConfig)) {
            return false;
        }
        LabelingJobOutputConfig other = (LabelingJobOutputConfig)obj;
        return Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn());
    }

    public final String toString() {
        return ToString.builder((String)"LabelingJobOutputConfig").add("S3OutputPath", (Object)this.s3OutputPath()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SnsTopicArn", (Object)this.snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobOutputConfig, T> g) {
        return obj -> g.apply((LabelingJobOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputPath;
        private String kmsKeyId;
        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobOutputConfig model) {
            this.s3OutputPath(model.s3OutputPath);
            this.kmsKeyId(model.kmsKeyId);
            this.snsTopicArn(model.snsTopicArn);
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public LabelingJobOutputConfig build() {
            return new LabelingJobOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobOutputConfig> {
        public Builder s3OutputPath(String var1);

        public Builder kmsKeyId(String var1);

        public Builder snsTopicArn(String var1);
    }
}

