/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.BatchStrategy;
import software.amazon.awssdk.services.sagemaker.model.DataProcessing;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelClientConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransformJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateTransformJobRequest> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobName").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::transformJobName)).setter(CreateTransformJobRequest.setter(Builder::transformJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::modelName)).setter(CreateTransformJobRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentTransforms").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::maxConcurrentTransforms)).setter(CreateTransformJobRequest.setter(Builder::maxConcurrentTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTransforms").build()}).build();
    private static final SdkField<ModelClientConfig> MODEL_CLIENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelClientConfig").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::modelClientConfig)).setter(CreateTransformJobRequest.setter(Builder::modelClientConfig)).constructor(ModelClientConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelClientConfig").build()}).build();
    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPayloadInMB").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::maxPayloadInMB)).setter(CreateTransformJobRequest.setter(Builder::maxPayloadInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()}).build();
    private static final SdkField<String> BATCH_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchStrategy").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::batchStrategyAsString)).setter(CreateTransformJobRequest.setter(Builder::batchStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchStrategy").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::environment)).setter(CreateTransformJobRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TransformInput> TRANSFORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformInput").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::transformInput)).setter(CreateTransformJobRequest.setter(Builder::transformInput)).constructor(TransformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformInput").build()}).build();
    private static final SdkField<TransformOutput> TRANSFORM_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformOutput").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::transformOutput)).setter(CreateTransformJobRequest.setter(Builder::transformOutput)).constructor(TransformOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOutput").build()}).build();
    private static final SdkField<TransformResources> TRANSFORM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformResources").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::transformResources)).setter(CreateTransformJobRequest.setter(Builder::transformResources)).constructor(TransformResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformResources").build()}).build();
    private static final SdkField<DataProcessing> DATA_PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProcessing").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::dataProcessing)).setter(CreateTransformJobRequest.setter(Builder::dataProcessing)).constructor(DataProcessing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProcessing").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::tags)).setter(CreateTransformJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperimentConfig").getter(CreateTransformJobRequest.getter(CreateTransformJobRequest::experimentConfig)).setter(CreateTransformJobRequest.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD, MODEL_NAME_FIELD, MAX_CONCURRENT_TRANSFORMS_FIELD, MODEL_CLIENT_CONFIG_FIELD, MAX_PAYLOAD_IN_MB_FIELD, BATCH_STRATEGY_FIELD, ENVIRONMENT_FIELD, TRANSFORM_INPUT_FIELD, TRANSFORM_OUTPUT_FIELD, TRANSFORM_RESOURCES_FIELD, DATA_PROCESSING_FIELD, TAGS_FIELD, EXPERIMENT_CONFIG_FIELD));
    private final String transformJobName;
    private final String modelName;
    private final Integer maxConcurrentTransforms;
    private final ModelClientConfig modelClientConfig;
    private final Integer maxPayloadInMB;
    private final String batchStrategy;
    private final Map<String, String> environment;
    private final TransformInput transformInput;
    private final TransformOutput transformOutput;
    private final TransformResources transformResources;
    private final DataProcessing dataProcessing;
    private final List<Tag> tags;
    private final ExperimentConfig experimentConfig;

    private CreateTransformJobRequest(BuilderImpl builder) {
        super(builder);
        this.transformJobName = builder.transformJobName;
        this.modelName = builder.modelName;
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.modelClientConfig = builder.modelClientConfig;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
        this.dataProcessing = builder.dataProcessing;
        this.tags = builder.tags;
        this.experimentConfig = builder.experimentConfig;
    }

    public final String transformJobName() {
        return this.transformJobName;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final Integer maxConcurrentTransforms() {
        return this.maxConcurrentTransforms;
    }

    public final ModelClientConfig modelClientConfig() {
        return this.modelClientConfig;
    }

    public final Integer maxPayloadInMB() {
        return this.maxPayloadInMB;
    }

    public final BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(this.batchStrategy);
    }

    public final String batchStrategyAsString() {
        return this.batchStrategy;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final TransformInput transformInput() {
        return this.transformInput;
    }

    public final TransformOutput transformOutput() {
        return this.transformOutput;
    }

    public final TransformResources transformResources() {
        return this.transformResources;
    }

    public final DataProcessing dataProcessing() {
        return this.dataProcessing;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelClientConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformJobRequest)) {
            return false;
        }
        CreateTransformJobRequest other = (CreateTransformJobRequest)((Object)obj);
        return Objects.equals(this.transformJobName(), other.transformJobName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.maxConcurrentTransforms(), other.maxConcurrentTransforms()) && Objects.equals(this.modelClientConfig(), other.modelClientConfig()) && Objects.equals(this.maxPayloadInMB(), other.maxPayloadInMB()) && Objects.equals(this.batchStrategyAsString(), other.batchStrategyAsString()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.transformInput(), other.transformInput()) && Objects.equals(this.transformOutput(), other.transformOutput()) && Objects.equals(this.transformResources(), other.transformResources()) && Objects.equals(this.dataProcessing(), other.dataProcessing()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.experimentConfig(), other.experimentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransformJobRequest").add("TransformJobName", (Object)this.transformJobName()).add("ModelName", (Object)this.modelName()).add("MaxConcurrentTransforms", (Object)this.maxConcurrentTransforms()).add("ModelClientConfig", (Object)this.modelClientConfig()).add("MaxPayloadInMB", (Object)this.maxPayloadInMB()).add("BatchStrategy", (Object)this.batchStrategyAsString()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("TransformInput", (Object)this.transformInput()).add("TransformOutput", (Object)this.transformOutput()).add("TransformResources", (Object)this.transformResources()).add("DataProcessing", (Object)this.dataProcessing()).add("Tags", this.hasTags() ? this.tags() : null).add("ExperimentConfig", (Object)this.experimentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobName": {
                return Optional.ofNullable(clazz.cast(this.transformJobName()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "MaxConcurrentTransforms": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentTransforms()));
            }
            case "ModelClientConfig": {
                return Optional.ofNullable(clazz.cast(this.modelClientConfig()));
            }
            case "MaxPayloadInMB": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadInMB()));
            }
            case "BatchStrategy": {
                return Optional.ofNullable(clazz.cast(this.batchStrategyAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "TransformInput": {
                return Optional.ofNullable(clazz.cast(this.transformInput()));
            }
            case "TransformOutput": {
                return Optional.ofNullable(clazz.cast(this.transformOutput()));
            }
            case "TransformResources": {
                return Optional.ofNullable(clazz.cast(this.transformResources()));
            }
            case "DataProcessing": {
                return Optional.ofNullable(clazz.cast(this.dataProcessing()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformJobRequest, T> g) {
        return obj -> g.apply((CreateTransformJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String transformJobName;
        private String modelName;
        private Integer maxConcurrentTransforms;
        private ModelClientConfig modelClientConfig;
        private Integer maxPayloadInMB;
        private String batchStrategy;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private TransformInput transformInput;
        private TransformOutput transformOutput;
        private TransformResources transformResources;
        private DataProcessing dataProcessing;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformJobRequest model) {
            super(model);
            this.transformJobName(model.transformJobName);
            this.modelName(model.modelName);
            this.maxConcurrentTransforms(model.maxConcurrentTransforms);
            this.modelClientConfig(model.modelClientConfig);
            this.maxPayloadInMB(model.maxPayloadInMB);
            this.batchStrategy(model.batchStrategy);
            this.environment(model.environment);
            this.transformInput(model.transformInput);
            this.transformOutput(model.transformOutput);
            this.transformResources(model.transformResources);
            this.dataProcessing(model.dataProcessing);
            this.tags(model.tags);
            this.experimentConfig(model.experimentConfig);
        }

        public final String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        public final ModelClientConfig.Builder getModelClientConfig() {
            return this.modelClientConfig != null ? this.modelClientConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelClientConfig(ModelClientConfig modelClientConfig) {
            this.modelClientConfig = modelClientConfig;
            return this;
        }

        public final void setModelClientConfig(ModelClientConfig.BuilderImpl modelClientConfig) {
            this.modelClientConfig = modelClientConfig != null ? modelClientConfig.build() : null;
        }

        public final Integer getMaxPayloadInMB() {
            return this.maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        public final String getBatchStrategy() {
            return this.batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy == null ? null : batchStrategy.toString());
            return this;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        public final TransformInput.Builder getTransformInput() {
            return this.transformInput != null ? this.transformInput.toBuilder() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return this.transformOutput != null ? this.transformOutput.toBuilder() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        public final TransformResources.Builder getTransformResources() {
            return this.transformResources != null ? this.transformResources.toBuilder() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        public final DataProcessing.Builder getDataProcessing() {
            return this.dataProcessing != null ? this.dataProcessing.toBuilder() : null;
        }

        @Override
        public final Builder dataProcessing(DataProcessing dataProcessing) {
            this.dataProcessing = dataProcessing;
            return this;
        }

        public final void setDataProcessing(DataProcessing.BuilderImpl dataProcessing) {
            this.dataProcessing = dataProcessing != null ? dataProcessing.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransformJobRequest build() {
            return new CreateTransformJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransformJobRequest> {
        public Builder transformJobName(String var1);

        public Builder modelName(String var1);

        public Builder maxConcurrentTransforms(Integer var1);

        public Builder modelClientConfig(ModelClientConfig var1);

        default public Builder modelClientConfig(Consumer<ModelClientConfig.Builder> modelClientConfig) {
            return this.modelClientConfig((ModelClientConfig)((ModelClientConfig.Builder)ModelClientConfig.builder().applyMutation(modelClientConfig)).build());
        }

        public Builder maxPayloadInMB(Integer var1);

        public Builder batchStrategy(String var1);

        public Builder batchStrategy(BatchStrategy var1);

        public Builder environment(Map<String, String> var1);

        public Builder transformInput(TransformInput var1);

        default public Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return this.transformInput((TransformInput)((TransformInput.Builder)TransformInput.builder().applyMutation(transformInput)).build());
        }

        public Builder transformOutput(TransformOutput var1);

        default public Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return this.transformOutput((TransformOutput)((TransformOutput.Builder)TransformOutput.builder().applyMutation(transformOutput)).build());
        }

        public Builder transformResources(TransformResources var1);

        default public Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return this.transformResources((TransformResources)((TransformResources.Builder)TransformResources.builder().applyMutation(transformResources)).build());
        }

        public Builder dataProcessing(DataProcessing var1);

        default public Builder dataProcessing(Consumer<DataProcessing.Builder> dataProcessing) {
            return this.dataProcessing((DataProcessing)((DataProcessing.Builder)DataProcessing.builder().applyMutation(dataProcessing)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

